% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WungLSkew}
\alias{WungLSkew}
\title{Ungauged pool weighted linear skewness (LSkew)}
\usage{
WungLSkew(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
the ungauged weighted LSkew from a pooling group
}
\description{
Calculates the ungauged weighted LSkew from a pooling group
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form an ungauged pooling group, and estimate ungauged LSkew
CDs.96001 <- GetCDs(96001)
Pool.96001 <- Pool(CDs.96001, exclude = 96001)
WungLSkew(Pool.96001)
}
\author{
Anthony Hammond
}
