% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMEDDonEq}
\alias{QMEDDonEq}
\title{QMED donor adjustment}
\usage{
QMEDDonEq(
  AREA,
  SAAR,
  FARL,
  BFIHOST,
  QMEDgObs,
  QMEDgCds,
  xSI,
  ySI,
  xDon,
  yDon,
  alpha = TRUE
)
}
\arguments{
\item{AREA}{catchment area in km2}

\item{SAAR}{standardised average annual rainfall in mm}

\item{FARL}{flood attenuation from reservoirs and lakes}

\item{BFIHOST}{the baseflow index as a function of soil type}

\item{QMEDgObs}{the observed QMED at the donor site}

\item{QMEDgCds}{the QMED equation derived QMED at the donor site}

\item{xSI}{the catchment centroid easting for the site of interest}

\item{ySI}{the catchment centroid northing for the site of interest}

\item{xDon}{the catchment centroid easting for the donor site}

\item{yDon}{the catchment centroid northing for the donor site}

\item{alpha}{a logical argument with a default of TRUE. When FALSE the exponent in the donor equation is set to one. Otherwise it is determined by the distance between the donor and the subject site}
}
\description{
Applies a donor adjustment to the median annual maximum flow (QMED) estimate
}
\details{
Although a single donor adjustment can be applied with the DonAdj() function and the QMED(), this is provided for flexibility. The method is that of Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation (2008).
}
\examples{
#Get observed QMED for site 15006
Qob <- median(GetAM(15006)[,2])
#Get QMED equation estimated QMED for the donor site
QCD <- QMED(CDs = GetCDs(15006))
#display CDs for site 27051 & note the easting and northing
GetCDs(27051)
#display CDs for site 15006 & note the easting and northing
GetCDs(15006)
#Apply the QMEDDonEq function with the information gained
QMEDDonEq(194, 1096, 0.955, 0.297, Qob, QCD, xSI = 289289,ySI = 947523,xDon = 280908,yDon = 953653)
}
\author{
Anthony Hammond
}
