% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\docType{data}
\name{state2010}
\alias{state2010}
\title{Centers of population of US states according to the 2010 census}
\format{
A \code{\link[tibble]{tibble}} with 52 rows and 5 columns

  \describe{

  \item{STATEFP}{The two-digit GEOID of the state}

  \item{STNAME}{The name of the state}

  \item{POPULATION}{The population of the state}

  \item{LATITUDE}{The latitude coordinate of the center of population
  (centroid) of the state (positive is north; negative is south)}

  \item{LONGITUDE}{The longitude coordinate of the center of population
  (centroid) of the state (positive is east; negative is west)}

  }
}
\source{
The source file is at
  \url{https://www2.census.gov/geo/docs/reference/cenpop2010/CenPop2010_Mean_ST.txt}.
   The 2010 center of population info page is at
  \url{https://www.census.gov/geographies/reference-files/time-series/geo/centers-population.2010.html}
}
\usage{
state2010
}
\description{
A data set of the latitude and longitude coordinates of the centers of
population (centroids) of the US states plus the District of Columbia and
Puerto Rico. Populations according to the 2010 decennial census are also
included.
}
\details{
Note that this contains Puerto Rico data, unlike \code{\link{state2000}}.
}
\examples{
state2010
}
\seealso{
Other 2010 census centers of population: \code{\link{county2010}};
  \code{\link{tract2010}}; \code{\link{block_group2010}};
  \code{\link{US_mean_center2010}}; \code{\link{US_median_center2010}}

  2000 census centers of population: \code{\link{state2000}};
  \code{\link{county2000}}; \code{\link{tract2000}};
  \code{\link{block_group2000}}
}
\keyword{datasets}
