% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-variogram.R
\docType{methods}
\name{variogram}
\alias{variogram}
\alias{variogram,UncertainPoints-method}
\title{Estimating of variograms}
\usage{
\S4method{variogram}{UncertainPoints}(object, model = c("Sph", "Exp", "Gau", "Ste"), 
   kappa = c(0.05, seq(0.2, 2, 0.1), 5, 10), fix.values = c(NA,NA,NA), verbose = FALSE, 
   GLS.model = NA, start_vals = c(NA,NA,NA), miscFitOptions = list())
}
\arguments{
\item{object}{Input data type of S4 object class UncertainPoints.}

\item{model}{The list of variogrammodels that will be tested.}

\item{kappa}{Smoothing parameter of the Matern model. Provide a list if you want to check more than one value.}

\item{fix.values}{Can be used to fix a variogram parameter to a certain value. It consists of a list with a length of three. The items describe the fixed value for the nugget, range and sill respectively.}

\item{verbose}{Logical, if TRUE the function will give extra feedback on the fitting process.}

\item{GLS.model}{If a variogram model is passed on through this parameter a Generalized Least Squares sample variogram is calculated.}

\item{start_vals}{Can be used to give the starting values for the variogram fitting. The items describe the fixed value for the nugget, range and sill respectively. They need to be given in that order. Setting the value to NA means that the value will be automatically chosen.}

\item{miscFitOptions}{A list with named arguments that provide additional control over the fitting process. For example: list(merge.small.bins = TRUE). If the list is empty, autofitVariogram uses default values.}
}
\value{
Returns an object of class \code{Variogram}.
}
\description{
This function can estimate variogram over the input data of S4 object 
class \code{UncertainPoints}. It is a bonus function of this whole 
package - just for user comfort. Output object is type of S4 class \code{Variogram} 
which can be printed by function \code{show} from UncerIn2 package. 
It also visualizes automaticaly all estimated variograms during the process.
}
\details{
For the estimation of variogram were used functions from package automap.
}
\seealso{
\code{\link[UncerIn2]{UncertainPoints-class}},  \code{\link[automap]{autofitVariogram}}, \code{\link[UncerIn2]{uncertaintyInterpolation2-package}}
}

