% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunAdaptiveUT.R
\name{RunAdaptiveUT}
\alias{RunAdaptiveUT}
\title{Simulates replications from the monotone utility based phase 12 trial.}
\usage{
RunAdaptiveUT(NSims, PE, PT, corET, Nmax, cohort, NF, UT, CutE, CutT,
  AcceptE, AcceptT, HypermeansE, HypermeansT, Hypervars)
}
\arguments{
\item{NSims}{Number of simulations.}

\item{PE}{True Efficacy Probability for each dose.}

\item{PT}{True toxicity probaiblity for each dose.}

\item{corET}{Correlation parameter between Efficacy and Toxicity status.}

\item{Nmax}{Maximum Sample size.}

\item{cohort}{Cohort Size.}

\item{NF}{Number of fixed assignment patients until adaptive randomization. If NF equals Nmax, the trial is conducted without adaptive randomization.}

\item{UT}{Utility Matrix with entries U11, U22 elicited and U12 equals 100, U21 equals 0.}

\item{CutE}{Cutoff for efficacy acceptability.}

\item{CutT}{Cutoff for toxicity acceptability.}

\item{AcceptE}{Probability threshold for efficacy acceptability.}

\item{AcceptT}{Probability threshold for toxicity acceptability.}

\item{HypermeansE}{Dose-specific hypermeans for efficacy.}

\item{HypermeansT}{Dose-specific hypermeans for toxcity.}

\item{Hypervars}{Length 3 vector of hypervariances. Hypervars[1] contains the Latent parameter variance for normal probability of efficacy and toxicity. Hypervars[2] contains the hypervariance on dose specific mean efficacy and toxicity parameters and Hypervars[3] contains the frailty variance parameter.}
}
\value{
A list of size NSims with results from each simulated trial. Each entry contains a list with (1) the optimal dose selected, (2) the posterior mean utility for each dose level, (3) a matrix containing the dose given, the efficacy outcome and the toxicity outcome for each patient.
}
\description{
Simulates trial replications from the monotone utility based phase 12 trial using either adaptive randomization or fixed dose assignment. Prints the true utility scores, dose selection probability, 
average number of patients treated at each dose, average number of responses, average number of toxicities, and Delta value. Returns trial outcomes.
}
\examples{
library(bindata)
library(mvtnorm)
##Trial PArameters here
Nmax=30 ##Number of patients to enroll
NF=30 ##Number until AR if NF=Nmax, there's no AR.
cohort=3
##UTILITIES
UT = matrix(c(38.23529,100,0,61.76471),nrow=2,byrow=TRUE)
##Safety Parameters
CutE=.3
CutT=.4
AcceptE=.1
AcceptT=.1
##Hyperparameters for Utility
HypermeansE=c(-1.189, -0.357,  0.360,  0.546,  0.743)
HypermeansT=c(-2.325, -1.811, -1.464, -1.189, -0.740)
Hypervars=c(1,36,1)
#True Efficacy and Toxicity probabilities
PE=c(.2,.4,.6,.7,.7)
PT=c(.2,.2,.2,.3,.5)
corET=0
##Number of simulations
NSims=2
RESULTS=RunAdaptiveUT(NSims, PE, PT, corET,  Nmax, 
cohort,NF, UT, CutE, CutT, AcceptE, 
AcceptT, HypermeansE, HypermeansT, Hypervars)
}
