% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{detection_check}
\alias{detection_check}
\title{Function for detection performance check}
\usage{
detection_check(pts.final, brk, nob, critval = 5)
}
\arguments{
\item{pts.final}{a list of estimated change points}

\item{brk}{the true change points}

\item{nob}{length of time series}

\item{critval}{critical value for selection rate. Default value is 5. Specifically, to compute the selection rate,  a selected break point is counted as a ``success'' for the \eqn{j}-th true break point, \eqn{t_j}, if it falls in the interval \eqn{[t_j - {(t_{j} - t_{j-1})}/{critval}, t_j + {(t_{j+1} - t_{j})}/{critval}]}, \eqn{j = 1,\dots, m_0}.}
}
\value{
a matrix of detection summary results, including the absolute error, selection rate and relative location. The absolute error of the locations of the estimated break points is defined as \eqn{{error}_j =|\tilde{t}_j^f - t_j|}, \eqn{j = 1,\dots, m_0}.
}
\description{
Function for detection performance check
}
\examples{
# an example of 10 replicates result
set.seed(1)
nob <- 1000
brk <- c(333, 666, nob+1)
cp.list <- vector('list', 10)
for(i in 1:10){
    cp.list[[i]] <-  brk[1:2] + sample(c(-50:50),1)
}
# some replicate fails to detect all the change point
cp.list[[2]] <- cp.list[[2]][1]
cp.list[4] <- list(NULL)      # setting 4'th element to NULL.
# some replicate overestimate the number of change point
cp.list[[3]] <- c(cp.list[[3]], 800)
cp.list
res <- detection_check(cp.list, brk, nob, critval = 5)
res
# use a stricter critical value
res <- detection_check(cp.list, brk, nob, critval = 10)
res

}
