% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsCvrt.R
\name{ts2vbt}
\alias{ts2vbt}
\title{Convert a structured character tensor to double list}
\usage{
ts2vbt(x, ...)
}
\arguments{
\item{x}{A structured character tensor to be converted.}

\item{...}{Argument in \code{\link[VBTree:chrvec2dl]{chrvec2dl}} to control split pattern.}
}
\value{
Return a vector binary tree based on the input tensor.
}
\description{
Convert a structured character tensor to a vector binary tree. All character elements in tensor will be splited by
a specific pattern then sorted intrinsically in each layer of the vector binary tree.
}
\examples{
#Write the column names of datatest into a tensor:
ts <- dl2ts(chrvec2dl(colnames(datatest)))

#Recover the vector binary tree from character tensor:
ts2vbt(ts)
}
\seealso{
\code{\link[VBTree:ts2dl]{ts2dl}}, \code{\link[VBTree:chrvec2dl]{chrvec2dl}}.
}
\keyword{Vector.Binary.Tree}
\keyword{tensor}
