% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getCI}
\alias{getCI}
\title{Extract Confidence Intervals from VCA-Objects.}
\usage{
getCI(
  obj,
  vc = NULL,
  type = c("vc", "sd", "cv"),
  tail = c("one-sided", "two-sided"),
  conf.level = 0.95,
  quiet = FALSE
)
}
\arguments{
\item{obj}{(object) of class "VCA"}

\item{vc}{(integer, character) specifying which variance component to extract CI for}

\item{type}{(character) on which scale should results be returned}

\item{tail}{(character) should one- or two-sided CI be returned}

\item{conf.level}{(numeric) confidence-level to be used}

\item{quiet}{(logical) TRUE = suppress additional information to be printed}
}
\description{
This utility function acutally calls function 'VCAinference' first and then extracts
the requested confidence interval (CI) information from the resulting object. You
can specify single variance components (VC) or multiple. Not specifying any specific
VC will return all.
}
\examples{
data(dataEP05A2_3)
fit <- remlVCA(y~day/run, dataEP05A2_3)
getCI(fit)				# will return one-sided CI for all VC
getCI(fit, type="cv")	# now on CV-scale
getCI(fit, type="cv", conf.level=.9)
# multiple row at once
getCI(fit, vc=1:3, type="cv")
getCI(fit, vc=c("total", "error"), type="cv")
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
