% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{coef.VFP}
\alias{coef.VFP}
\title{Extract Model-Coefficients from VFP-Objects.}
\usage{
\method{coef}{VFP}(object, model.no = NULL, ...)
}
\arguments{
\item{object}{(object) of class "VFP"}

\item{model.no}{(integer) specifying one of models 1:10, must be one of the 
fitted models}

\item{...}{additional parameters passed forward}
}
\description{
Extract Model-Coefficients from VFP-Objects.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
mat <- getMat.VCA(lst)		# automatically selects "total"
res <- fit.vfp(model.no=1:10, Data=mat)
coef(res)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
			Florian Dufey \email{florian.dufey@roche.com}
}
