% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_avg_diff}
\alias{plot_avg_diff}
\title{Plots average difference between looks to interest areas.}
\usage{
plot_avg_diff(data, DiffCols = NULL, xlim = NA, Condition1 = NA,
  Condition2 = NA, Cond1Labels = NA, Cond2Labels = NA, ErrorBar = TRUE,
  VWPreTheme = TRUE)
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}}. 
\code{\link{transform_to_elogit}}, or \code{\link{create_binomial}}.}

\item{DiffCols}{A named character vector specifying the desired columns 
corresponding to the interest areas.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{Condition1}{A string containing the column name corresponding to the 
first condition, if available.}

\item{Condition2}{A string containing the column name corresponding to the 
second condition, if available.}

\item{Cond1Labels}{A named character vector specifying the desired labels 
of the levels of the first condition.}

\item{Cond2Labels}{A named character vector specifying the desired labels 
of the levels of the second condition.}

\item{ErrorBar}{A logical indicating whether standard error bars should 
included in the plot.}

\item{VWPreTheme}{A logical indicating whether the theme included with the 
function should be applied, or ggplot2's base theme (which any other 
custom theme could be added).}
}
\description{
\code{plot_avg_diff} calculates the grand or conditional averages of 
differences between looks to two interest area along with standard error. 
It then plots the results.
}
\examples{
\dontrun{
library(VWPre)
# For plotting grand average differences...
plot_avg_diff(data = dat, xlim = c(0, 1000), DiffCols = c(IA_1_P = "Target", IA_2_P = "Rhyme"),
             Condition1 = NA, Condition2 = NA, Cond1Labels = NA, Cond2Labels = NA,
             ErrorBar = TRUE, VWPreTheme = TRUE)
             
# For plotting conditional average differences (one condition) with the included theme.
plot_avg_diff(data = dat, xlim = c(0, 1000), DiffCols = c(IA_1_P = "Target", IA_2_P = "Rhyme"), 
           Condition1 = "talker", Condition2 = NA, Cond1Labels = c(CH1 = "Chinese 1", 
           CH10 = "Chinese 3", CH9 = "Chinese 2", EN3 = "English 1"),
           Cond2Labels = NA, ErrorBar = TRUE, VWPreTheme = TRUE)
           
# For plotting conditional average differences (two conditions) with the included theme.
plot_avg_diff(data = dat, xlim = c(0, 1000), DiffCols = c(IA_1_P = "Target", IA_2_P = "Rhyme"), 
           Condition1 = "talker", Condition2 = "Exp", Cond1Labels = c(CH1 = "Chinese 1", 
           CH10 = "Chinese 3", CH9 = "Chinese 2", EN3 = "English 1"),
           Cond2Labels = c(High = "H Exp", Low = "L Exp"), ErrorBar = TRUE, 
           VWPreTheme = TRUE)
}
}
