% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_chol.R
\name{get_sp_inv_chol}
\alias{get_sp_inv_chol}
\title{Get the inverse upper Cholesky factor under the Vecchia approximation}
\usage{
get_sp_inv_chol(covMat, NNarray)
}
\arguments{
\item{covMat}{the covariance matrix}

\item{NNarray}{n X (m + 1) matrix representing the nearest neighbor indices
among previous observations. This is typically the return of
GpGp::find_ordered_nn}
}
\value{
upper Cholesky of the inverse of `covMat`
}
\description{
Get the inverse upper Cholesky factor under the Vecchia approximation
}
\examples{
library(GpGp)
n1 <- 10
n2 <- 10
n <- n1 * n2
locs <- as.matrix(expand.grid((1:n1) / n1, (1:n2) / n2))
covparms <- c(2, 0.3, 0)
cov_mat <- GpGp::matern15_isotropic(covparms, locs)
m <- 30
NNarray <- GpGp::find_ordered_nn(locs, m = m)
# Vecchia approx --------------------------------
U_Vecc <- get_sp_inv_chol(cov_mat, NNarray)
U <- solve(chol(cov_mat))
cat("Frobenius norm of the difference is", sqrt(sum((U - U_Vecc)^2)))

}
