% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertTFCE.R
\name{TFCE.vertex_analysis}
\alias{TFCE.vertex_analysis}
\title{Vertex-wise analysis with TFCE (fixed effect)}
\usage{
TFCE.vertex_analysis(
  model,
  contrast,
  surf_data,
  nperm = 100,
  tail = 2,
  nthread = 10,
  smooth_FWHM,
  VWR_check = TRUE
)
}
\arguments{
\item{model}{An N X V data.frame object containing N rows for each subject and V columns for each predictor included in the model}

\item{contrast}{A numeric vector or object containing the values of the predictor of interest. The t-stat and TFCE maps will be estimated only for this predictor}

\item{surf_data}{A matrix object containing the surface data, see SURFvextract() or HIPvextract() output format.}

\item{nperm}{A numeric integer object specifying the number of permutations generated for the subsequent thresholding procedures (default = 100)}

\item{tail}{A numeric integer object specifying whether to test a one-sided positive (1), one-sided negative (-1) or two-sided (2) hypothesis}

\item{nthread}{A numeric integer object specifying the number of CPU threads to allocate}

\item{smooth_FWHM}{A numeric vector object specifying the desired smoothing width in mm}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A list object containing the t-stat and the TFCE statistical maps which can then be subsequently thresholded using TFCE.threshold()
}
\description{
Fits a linear model with the cortical or hippocampal surface data as the predicted outcome, and returns t-stat and TFCE statistical maps for the selected contrast.
}
\details{
This TFCE method is adapted from the \href{https://github.com/nilearn/nilearn/blob/main/nilearn/mass_univariate/_utils.py#L7C8-L7C8}{ 'Nilearn' Python library}.
}
\examples{
demodata = readRDS(system.file('demo_data/SPRENG_behdata_site1.rds',
package = 'VertexWiseR'))[1:5,]
surf_data = readRDS(file = url(paste0("https://github.com",
"/CogBrainHealthLab/VertexWiseR/blob/main/inst/demo_data/",
"SPRENG_CTv_site1.rds?raw=TRUE")))[1:5,]
model=demodata[,c(2,7)]
contrast=demodata[,7]

TFCE.pos=TFCE.vertex_analysis(model, contrast, surf_data, tail=1, 
nperm=5, nthread = 2, VWR_check=FALSE)

#To threshold the results, you may then run:
#results=TFCE.threshold(TFCE.pos, p=0.05, atlas=1)
#results$cluster_level_results

}
\seealso{
\code{\link{TFCE.threshold}}
}
