% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertmixedTFCE.R
\name{TFCE_vertex_analysis_mixed}
\alias{TFCE_vertex_analysis_mixed}
\title{Vertex-wise analysis with threshold-free cluster enhancement (mixed effect)}
\usage{
TFCE_vertex_analysis_mixed(
  model,
  contrast,
  random,
  formula,
  formula_dataset,
  surf_data,
  nperm = 100,
  tail = 2,
  nthread = 10,
  smooth_FWHM,
  perm_type = "row",
  VWR_check = TRUE
)
}
\arguments{
\item{model}{An N X P data.frame object containing N rows for each subject and P columns for each predictor included in the model.This data.frame should not include the random effects variable.}

\item{contrast}{A N x 1 numeric vector or object containing the values of the predictor of interest. Its length should equal the number of subjects in model (and can be a single column from model). The t-stat and TFCE maps will be estimated only for this predictor.}

\item{random}{A N x 1 numeric vector or object containing the values of the random variable (optional). Its length should be equal to the number of subjects in model (it should NOT be inside the model data.frame).}

\item{formula}{An optional string or formula object describing the predictors to be fitted against the surface data, replacing the model, contrast, or random arguments. If this argument is used, the formula_dataset argument must also be provided.
\itemize{
\item The dependent variable is not needed, as it will always be the surface data values.
\item The first independent variable in the formula will always be interpreted as the contrast of interest for which to estimate cluster-thresholded t-stat maps.
\item Only one random regressor can be given and must be indicated as '(1|variable_name)'.
}}

\item{formula_dataset}{An optional data.frame object containing the independent variables to be used with the formula (the IV names in the formula must match their column names in the dataset).}

\item{surf_data}{A N x V matrix object containing the surface data (N row for each subject, V for each vertex), in fsaverage5 (20484 vertices), fsaverage6 (81924 vertices), fslr32k (64984 vertices) or hippocampal (14524 vertices) space. See also Hipvextract(), SURFvextract() or FSLRvextract output formats.}

\item{nperm}{A numeric integer object specifying the number of permutations generated for the subsequent thresholding procedures (default = 100)}

\item{tail}{A numeric integer object specifying whether to test a one-sided positive (1), one-sided negative (-1) or two-sided (2) hypothesis}

\item{nthread}{A numeric integer object specifying the number of CPU threads to allocate}

\item{smooth_FWHM}{A numeric vector object specifying the desired smoothing width in mm}

\item{perm_type}{A string object specifying whether to permute the rows ("row"), between subjects ("between"), within subjects ("within") or between and within subjects ("within_between") for random subject effects. Default is "row".}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A list object containing the t-stat and the TFCE statistical maps which can then be subsequently thresholded using TFCE_threshold()
}
\description{
Fits a linear mixed effects model with the cortical or hippocampal surface data as the predicted outcome, and returns t-stat and threshold-free cluster enhancement (TFCE) statistical maps for the selected contrast.
}
\details{
This TFCE method is adapted from the \href{https://github.com/nilearn/nilearn/blob/main/nilearn/mass_univariate/_utils.py#L7C8-L7C8}{'Nilearn' Python library}.
}
\examples{
demodata = readRDS(system.file('demo_data/SPRENG_behdata_site1.rds', package = 'VertexWiseR'))[1:5,]
CTv = readRDS(file = url(paste0("https://github.com",
"/CogBrainHealthLab/VertexWiseR/blob/main/inst/demo_data/",
"SPRENG_CTv_site1.rds?raw=TRUE")))[1:5,]

TFCEpos=TFCE_vertex_analysis_mixed(model=demodata[,c("sex",
"age")], contrast=demodata[,"age"], random=demodata[,"id"], 
surf_data=CTv, nperm =5,tail = 1, nthread = 2, VWR_check=FALSE)

#To get significant clusters, you may then run:
#results=TFCE_threshold(TFCEpos, p=0.05, atlas=1)
#results$cluster_level_results

#Formula alternative:
#formula= as.formula("~ age + sex + (1|id)")
#TFCEpos=TFCE_vertex_analysis_mixed(formula=formula, 
#formula_dataset=demodata, surf_data=CTv, tail=1, 
#nperm=5, nthread = 2, VWR_check=FALSE) 

}
\seealso{
\code{\link{RFT_vertex_analysis}},  \code{\link{TFCE_vertex_analysis}}, \code{\link{TFCE_threshold}}
}
