% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaMatrix.R
\name{BetaMatrix}
\alias{BetaMatrix}
\title{Matrix of Empirical Blomqvist's Beta Values}
\usage{
BetaMatrix(data)
}
\arguments{
\item{data}{An N x d data matrix.}
}
\value{
Matrix of the empirical Blomqvist's betas.
}
\description{
This function computes the empirical Blomqvist's beta.
}
\examples{

data(daxreturns)
data <- as.matrix(daxreturns)

# compute the empirical Blomqvist's betas
BetaMatrix(data)

}
\author{
Ulf Schepsmeier
}
\references{
Blomqvist, N. (1950).  On a measure of dependence between two
random variables. The Annals of Mathematical Statistics, 21(4), 593-600.

Nelsen, R. (2006). An introduction to copulas.  Springer
}
\seealso{
\code{\link{TauMatrix}}, \code{\link{BiCopPar2Beta}},
\code{\link{RVinePar2Beta}}
}

