% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopDeriv2.R
\name{BiCopDeriv2}
\alias{BiCopDeriv2}
\title{Second Derivatives of a Bivariate Copula Density}
\usage{
BiCopDeriv2(
  u1,
  u2,
  family,
  par,
  par2 = 0,
  deriv = "par",
  obj = NULL,
  check.pars = TRUE
)
}
\arguments{
\item{u1, u2}{numeric vectors of equal length with values in \eqn{[0,1]}.}

\item{family}{integer; single number or vector of size \code{length(u1)};
defines the bivariate copula family:  \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{13} = rotated Clayton copula (180 degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr
\code{23} = rotated Clayton copula (90 degrees) \cr
`24` = rotated Gumbel copula (90 degrees) \cr
`26` = rotated Joe copula (90 degrees) \cr
`33` = rotated Clayton copula (270 degrees) \cr
`34` = rotated Gumbel copula (270 degrees) \cr
`36` = rotated Joe copula (270 degrees) \cr}

\item{par}{Copula parameter.}

\item{par2}{integer; single number or vector of size \code{length(u1)};
second parameter for the t-Copula; default is \code{par2 = 0}, should be an
positive integer for the Students's t copula \code{family = 2}.}

\item{deriv}{Derivative argument \cr
\code{"par"} = second derivative with respect to
the first parameter (default)\cr
\code{"par2"} = second derivative with respect to
the second parameter (only available for the t-copula) \cr
\code{"u1"} = second derivative with respect to
the first argument \code{u1} \cr
\code{"u2"} = second derivative with respect to
the second argument \code{u2} \cr
\code{"par1par2"} = second derivative with respect to
the first and second parameter (only available for the t-copula)
\cr \code{"par1u1"} = second derivative with respect to
the first parameter and the first argument \cr
\code{"par2u1"} = second derivative with respect to the
second parameter and the first argument (only available for the t-copula) \cr
\code{"par1u2"} = second derivative with respect to
the first parameter and the second argument \cr
\code{"par2u2"} = second derivative with respect to
the second parameter and the second argument
(only available for the t-copula) \cr}

\item{obj}{\code{BiCop} object containing the family and parameter
specification.}

\item{check.pars}{logical; default is \code{TRUE}; if \code{FALSE}, checks
for family/parameter-consistency are omitted (should only be used with
care).}
}
\value{
A numeric vector of the second-order bivariate copula derivative
\itemize{
\item of the copula \code{family}
\item with parameter(s) \code{par}, \code{par2}
\item with respect to \code{deriv}
\item evaluated at \code{u1} and \code{u2}.
}
}
\description{
This function evaluates the second derivative of a given parametric
bivariate copula density with respect to its parameter(s) and/or its
arguments.
}
\details{
If the family and parameter specification is stored in a \code{\link[=BiCop]{BiCop()}}
object \code{obj}, the alternative version \cr
\preformatted{BiCopDeriv2(u1, u2, obj, deriv = "par")}
can be used.
}
\examples{

## simulate from a bivariate Student-t copula
set.seed(123)
cop <- BiCop(family = 2, par = -0.7, par2 = 4)
simdata <- BiCopSim(100, cop)

## second derivative of the Student-t copula w.r.t. the first parameter
u1 <- simdata[,1]
u2 <- simdata[,2]
BiCopDeriv2(u1, u2, cop, deriv = "par")

## estimate a Student-t copula for the simulated data
cop <- BiCopEst(u1, u2, family = 2)
## and evaluate its second derivative w.r.t. the second argument u2
BiCopDeriv2(u1, u2, cop, deriv = "u2")

}
\references{
Schepsmeier, U. and J. Stoeber (2014). Derivatives and Fisher
information of bivariate copulas. Statistical Papers, 55 (2), 525-542. \cr
\url{http://link.springer.com/article/10.1007/s00362-013-0498-x}.
}
\seealso{
\code{\link[=RVineGrad]{RVineGrad()}}, \code{\link[=RVineHessian]{RVineHessian()}},
\code{\link[=BiCopDeriv]{BiCopDeriv()}}, \code{\link[=BiCopHfuncDeriv]{BiCopHfuncDeriv()}}, \code{\link[=BiCop]{BiCop()}}
}
\author{
Ulf Schepsmeier, Jakob Stoeber
}
