% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pobs.R
\name{EmpCDF}
\alias{EmpCDF}
\title{Corrected Empirical CDF}
\usage{
EmpCDF(x)
}
\arguments{
\item{x}{numeric vector of observations}
}
\value{
A function with signature \verb{function(x)} that returns \eqn{F_n(x)}.
}
\description{
The empirical CDF with tail correction, ensuring that its output is never
0 or 1.
}
\details{
The corrected empirical CDF is defined as
\deqn{
F_n(x) = \frac{1}{n + 1} \min\biggl\{1, \sum_{i = 1}^n 1(X_i \le x)\biggr\}
}
}
\examples{
# fit ECDF on simulated data
x <- rnorm(100)
cdf <- EmpCDF(x)

# output is bounded away from 0 and 1
cdf(-50)
cdf(50)
}
