% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVirusPlot.R
\name{ExportVirusPlot}
\alias{ExportVirusPlot}
\title{Export Virusparies Plots}
\usage{
ExportVirusPlot(
  file_name,
  export_plotobj = FALSE,
  plot = NULL,
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  ...,
  align = "none",
  axis = "none",
  nrow = NULL,
  ncol = NULL,
  rel_widths = 1,
  rel_heights = 1,
  labels = NULL,
  label_size = 14,
  label_fontfamily = NULL,
  label_fontface = "bold",
  label_colour = NULL,
  label_x = 0,
  label_y = 1,
  hjust = -0.5,
  vjust = 1.5,
  scale_grid = 1,
  greedy = TRUE,
  byrow = TRUE
)
}
\arguments{
\item{file_name}{Name of the output file.}

\item{export_plotobj}{(optional): If TRUE, exports the plot object in rds format with the same name as specified in file_name (default: FALSE).}

\item{plot}{The plot to be exported.}

\item{device}{The device used for output.
Can be one of "eps", "ps", "tex", "pdf", "jpeg", "tiff", "png", "bmp", "svg", or "wmf" (windows only).
If NULL (default), the device is guessed based on the filename extension.}

\item{path}{The directory where the plot will be saved. Default is NULL (working directory).}

\item{scale}{A scaling factor (default: 1).}

\item{width}{The width of the output file.}

\item{height}{The height of the output file.}

\item{units}{The units of the width and height parameters.
Can be one of "in", "cm", "mm", or "px".}

\item{dpi}{The resolution of the output device in dots per inch (default: 300).}

\item{limitsize}{Whether to limit the size of the output file to the dimensions of the plot (default: TRUE).}

\item{...}{Additional arguments passed to.}

\item{align}{Specifies alignment of plots in the grid: "none" (default), "hv" (both directions), "h" (horizontally), or "v" (vertically).}

\item{axis}{Specifies alignment of plots by margins: "none" (default), or any combo of left ("l"), right ("r"), top ("t"), or bottom ("b")(e.g., "tblr" or "rlbt").}

\item{nrow}{(optional): Number of rows in the plot grid (default: NULL).}

\item{ncol}{(optional): Number of columns in the plot grid (default: NULL).}

\item{rel_widths}{Numeric vector of relative column widths. Default is 1 (equal widths).}

\item{rel_heights}{Numeric vector of relative row heights. Default is 1 (equal heights).}

\item{labels}{List of labels for plots. Default is NULL (no labels).labels="auto" and labels="AUTO" auto-generate lower and upper-case labels.}

\item{label_size}{Numeric label size (default: 14).}

\item{label_fontfamily}{Font family for labels. Default is NULL (theme default).}

\item{label_fontface}{Font face for labels (default: "bold").}

\item{label_colour}{Color for labels. Default is NULL (theme default).}

\item{label_x}{Single value/vector of x positions for labels,relative to each subplot. Default is 0 (left).}

\item{label_y}{Single value/vector of y positions for labels, relative to each subplot. Default is 1 (top).}

\item{hjust}{Horizontal adjustment for labels (default: -0.5).}

\item{vjust}{Vertical adjustment for labels (default: 1.5).}

\item{scale_grid}{Single value/vector > 0. Enables you to scale the size of all or select plots.}

\item{greedy}{Margin adjustment during alignment (default: TRUE).}

\item{byrow}{Arrange plots by row (TRUE, default) or column (FALSE).}
}
\value{
a message indicating that export was successful.
}
\description{
ExportVirusPlot allows the user to export plots in different formats.
}
\details{
Export plots generated by functions within the Virusparies package.

ExportVirusPlot exports plots in various formats supported by Virusparies.
Supported devices include "eps", "ps", "tex", "pdf", "jpeg", "tiff", "png", "bmp", "svg", or "wmf" (Windows only).
When 'device' is set to NULL, the file extension in \code{filename} is used to determine the device.

Depending on the plot, the final image might be cropped or truncated.
We recommend experimenting with height, width, and resolution.

In addition, users can generate a grid layout containing multiple plots when a list containing multiple plots is provided as input.
This will then be exported using the chosen device.

The following arguments are only used for export with grid layout:
\itemize{
\item \code{align}: Specifies how plots are aligned within the grid.
\item \code{axis}: Controls alignment of plots by margins.
\item \code{nrow}, \code{ncol}: Define the structure of the plot grid.
\item \code{rel_widths}, \code{rel_heights}: Adjust relative column and row sizes.
\item \code{labels}, \code{label_size}, \code{label_fontfamily}, \code{label_fontface}, \code{label_colour}, \code{label_x}, \code{label_y}, \code{hjust}, \code{vjust}: Customize plot labels.
\item \code{scale_grid}: Enables you to scale the size of all or select plots.
\item \code{greedy}: Determines margin adjustments during alignment.
\item \code{byrow}: Specifies the arrangement of plots in the grid.
}

\code{export_plotobj} = TRUE exports the plot in the specified format (e.g., PNG, PDF, etc.)
and also saves the plot object in .rds format with the same file name. This allows the user to
import the plot object into R using the \code{readRDS} function and modify the plot further as needed.
}
\examples{
path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
vh_file <- ImportVirusTable(path)

# Basic plot
plot <- VhgIdentityScatterPlot(vh_file,cutoff = 1e-5)

\donttest{

# first export
ExportVirusPlot(plot=plot$plot,file_name="testplot.png",width=8,height=6,
units="in",path=tempdir())

# second export with device argument
ExportVirusPlot(plot=plot$plot,file_name="testplot",width=8,height=6,
units="in",device = "png",path=tempdir())

}

## example 2 for multiple plots in 1 pdf file.

path2 <- system.file("extdata", "virusgatherer.tsv", package = "Virusparies")
vg_file <- ImportVirusTable(path2)

# Generate 3 plots
violinplot <- VgConLenViolin(vg_file=vg_file,cut = 1e-5,log10_scale = TRUE,
legend_position = "none",title = "",xlabel = "",reorder_criteria = NULL,
                             theme_choice = "minimal")
srarun <- VhgRunsBarplot(file = vg_file,groupby = "ViralRefSeq_taxonomy",
legend_position = "none",title = "",xlabel = "",reorder_criteria = NULL,
                         theme_choice = "minimal")
boxplot <- VhgBoxplot(vg_file,x_column = "ViralRefSeq_taxonomy",y_column = "ViralRefSeq_ident",
legend_position = "bottom",title = "",xlabel = "",
                      reorder_criteria = NULL,theme_choice = "minimal")

# add plots to a list
plot_list <- list(violinplot$plot,srarun$plot,boxplot$boxp)

\donttest{

ExportVirusPlot(plot=plot_list,file_name="grid_testplot.pdf",width=16,height=12,
units="in",nrow = 3,ncol = 1,path=tempdir())

}

}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
