% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableplot.R
\name{tableplot}
\alias{tableplot}
\alias{tableplot.default}
\title{Tableplot: A Semi-graphic Display of a Table}
\usage{
tableplot(values, ...)

\method{tableplot}{default}(
  values,
  types,
  patterns = list(list(0, "black", 1, "white", "white", 0, 0.5, "grey80", FALSE, 1)),
  title = "Tableplot",
  side.label = "row",
  top.label = "col",
  table.label = TRUE,
  label.size = 1,
  side.rot = 0,
  gap = 2,
  v.parts = 0,
  h.parts = 0,
  cor.matrix = FALSE,
  var.names = "var",
  ...
)
}
\arguments{
\item{values}{A matrix or 3-dimensional array of values to be displayed in a tableplot}

\item{...}{Arguments passed down to \code{tableplot.default}}

\item{types}{Matrix of specification assignments, of the same size as the first two dimensions
of \code{values}. Entries refer to the sub-lists of \code{patterns}.
Defaults to a matrix of all 1s, \code{matrix(1, dim(values)[1], dim(values[2]))},
indicating that all cells use the same pattern specification.}

\item{patterns}{List of lists; each list is one specification for the arguments to \code{\link{cellgram}}.}

\item{title}{Main title}

\item{side.label}{a character vector providing labels for the rows of the tableplot}

\item{top.label}{a character vector providing labels for the columns of the tableplot}

\item{table.label}{Whether to print row/column labels}

\item{label.size}{Character size for labels}

\item{side.rot}{Degree of rotation (positive for counter-clockwise)}

\item{gap}{Width of the gap in each partition, if partitions are requested by \code{v.parts}
and/or \code{h.parts}}

\item{v.parts}{An integer vector giving the number of columns in two or more partitions of
the table. If provided, sum must equal number of columns.}

\item{h.parts}{An integer vector giving the number of rows in two or more partitions of
the table. If provided, sum must equal number of rows.}

\item{cor.matrix}{Logical. \code{TRUE} for a correlation matrix}

\item{var.names}{a list of variable names}
}
\value{
None. Used for its graphic side effect
}
\description{
A tableplot (Kwan, 2008) is
designed as a semi-graphic display in the form of a table with numeric values, but supplemented
by symbols with size proportional to cell value(s), and with other visual attributes
(shape, color fill, background fill, etc.) that can be used to encode other information
essential to direct visual understanding.  Three-way arrays, where the last dimension
corresponds to levels of a factor for which the first two dimensions are to be compared
are handled by superimposing symbols.

The specifications for each cell are given by the \code{types} argument, whose elements refer
to the attributes specified in \code{patterns.}
}
\note{
The original version of tableplots was in the now-defunct tableplot package
\url{https://cran.r-project.org/package=tableplot}. The current implementation
is a modest re-design focused on its use for collinearity diagnostics, but usable in
more general contexts.
}
\examples{
data(cars)
cars.mod <- lm (mpg ~ cylinder + engine + horse + weight + accel + year,
                data=cars)
car::vif(cars.mod)

(cd <- colldiag(cars.mod, center=TRUE))
tableplot(cd, title = "Tableplot of cars data", cond.max = 30 )

}
\references{
Kwan, E. (2008).
Improving Factor Analysis in Psychology: Innovations Based on the Null Hypothesis Significance
Testing Controversy. Ph. D. thesis,  York University.
}
\seealso{
\code{\link{cellgram}}
}
\author{
Ernest Kwan and Michael Friendly
}
