% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noaa_datums.R
\name{noaa.datums}
\alias{noaa.datums}
\title{Scrapes elevation datums from NOAA CO-OPS website}
\usage{
noaa.datums(station = 8467150)
}
\arguments{
\item{station}{station name or ID number, available on the CO-OPS website or by 
using \code{\link{noaa.stations}}. Entry can be numeric (station ID) or a string 
corresponding to the station name. Default station is Bridgeport, CT.}
}
\value{
a dataframe of vertical datum names and their elevations in meters 
relative to the station datum for the 1983-2001 epoch. Also contains a column 
of times associated with relevant datums (record maximum and minimums, lowest 
and highest astronomical tides).
}
\description{
Scrapes elevation datums from NOAA CO-OPS website
}
\details{
Scrapes elevation datums from NOAA CO-OPS website. 
Requires an internet connection.
}
\examples{
\dontrun{
# examples require internet connection
bport.datums <- noaa.datums() # Bridgeport, CT
battery.datums <- noaa.datums(station = 8518750) # Battery, NYC
}
}
\seealso{
\code{\link{noaa}}, \code{\link{noaa.stations}}
}
