% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{add_reactevt}
\alias{add_reactevt}
\title{Define the modifications to other events, costs, utilities, or other items affected by the occurrence of the event}
\usage{
add_reactevt(.data = NULL, name_evt, input)
}
\arguments{
\item{.data}{Existing data for event reactions}

\item{name_evt}{Name of the event for which reactions are defined.}

\item{input}{Expressions that define what happens at the event, using functions as defined in the Details section}
}
\value{
A named list with the event name, and inside it the substituted expression saved for later evaluation
}
\description{
Define the modifications to other events, costs, utilities, or other items affected by the occurrence of the event
}
\details{
There are a series of objects that can be used in this context to help define the event reactions.

The following functions may be used to define event reactions within this \code{add_reactevt()} function:
\code{modify_item()} | Adds & Modifies items/flags/variables for future events (does not consider sequential)
\code{modify_item_seq()} | Adds & Modifies items/flags/variables for future events in a sequential manner
\code{new_event()} | Adds events to the vector of events for that patient
\code{modify_event()} | Modifies existing events by changing their time

Apart from the items defined with add_item(), we can also use standard variables that are always defined within the simulation:
\code{curtime} | Current event time (numeric)
\code{prevtime} | Time of the previous event (numeric)
\code{cur_evtlist} | Named vector of events that is yet to happen for that patient (named numeric vector)
\code{evt} | Current event being processed (character)
\code{i} | Patient being iterated (character)
\code{simulation} | Simulation being iterated (numeric)

The model will run until \code{curtime} is set to \code{Inf}, so the event that terminates the model should modify \code{curtime} and set it to \code{Inf}.

The user can use \code{extract_from_reactions} function on the output to obtain a data.frame with all the relationships defined in the reactions in the model.
}
\examples{
add_reactevt(name_evt = "start",input = {})
add_reactevt(name_evt = "idfs",input = {modify_item(list("fl.idfs"= 0))})
}
