% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Rossler.R
\name{data.gen.Rossler}
\alias{data.gen.Rossler}
\title{Generate predictor and response data: Rossler system}
\usage{
data.gen.Rossler(
  a = 0.2,
  b = 0.2,
  w = 5.7,
  start = c(-2, -10, 0.2),
  time = seq(0, 50, length.out = 5000)
)
}
\arguments{
\item{a}{The \emph{a} parameter. Default:0.2.}

\item{b}{The \emph{b} parameter. Default: 0.2.}

\item{w}{The \emph{w} parameter. Default: 5.7.}

\item{start}{A 3-dimensional numeric vector indicating the starting point for the time series. Default: c(-2, -10, 0.2).}

\item{time}{The temporal interval at which the system will be generated.
Default: time=seq(0,50,length.out = 5000).}
}
\value{
A list with four vectors named \emph{time}, \emph{x}, \emph{y}
and \emph{z} containing the time, the x-components, the
y-components and the z-components of the Rossler system, respectively.
}
\description{
Generates a 3-dimensional time series using the Rossler equations.
}
\details{
The Rossler system is a system of ordinary differential equations defined as:
\deqn{\dot{x} = -(y + z)}{dx/dt = -(y + z)}
\deqn{\dot{y} = x+a \cdot y}{dy/dt = x + a*y}
\deqn{\dot{z} = b + z*(x-w)}{dz/dt = b + z*(x-w)}
The default selection for the system parameters (\emph{a} = 0.2, \emph{b} = 0.2, \emph{w} = 5.7) is known to
produce a deterministic chaotic time series.
}
\note{
Some initial values may lead to an unstable system that will tend to infinity.
}
\examples{
### synthetic example - Rossler
ts.r <- data.gen.Rossler(
  a = 0.2, b = 0.2, w = 5.7, start = c(-2, -10, 0.2),
  time = seq(0, 50, length.out = 1000)
)

# add noise
ts.r$x <- ts(ts.r$x + rnorm(length(ts.r$time), mean = 0, sd = 1))
ts.r$y <- ts(ts.r$y + rnorm(length(ts.r$time), mean = 0, sd = 1))
ts.r$z <- ts(ts.r$z + rnorm(length(ts.r$time), mean = 0, sd = 1))

ts.plot(ts.r$x, ts.r$y, ts.r$z, col = c("black", "red", "blue"))
}
\references{
RÖSSLER, O. E. 1976. An equation for continuous chaos. Physics Letters A, 57, 397-398.
}
