% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_quantile_curves.R
\name{simulate_quantile_curves}
\alias{simulate_quantile_curves}
\title{Simulate quantile curves}
\usage{
simulate_quantile_curves(x1, alpha, beta, t_vec)
}
\arguments{
\item{x1}{n-by-1 predictor vector}

\item{alpha}{parameter in location transformation}

\item{beta}{parameter in variance transformation}

\item{t_vec}{a length m vector - common grid for all quantile functions}
}
\value{
{quan_obs} {n-by-m matrix of quantile functions}
}
\description{
This function simulates quantile curves used as a toy example
}
\examples{
alpha = 2
beta = 1
n = 100
x1 = runif(n)
t_vec = unique(c(seq(0, 0.05, 0.001), seq(0.05, 0.95, 0.05), seq(0.95, 1, 0.001)))
quan_obs = simulate_quantile_curves(x1, alpha, beta, t_vec)
}
\references{
\cite{Wasserstein F-tests and confidence bands for the Frechet regression of density response curves, Alexander Petersen, Xi Liu and Afshin A. Divani, 2019}
}
