% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prdnrmplot.R
\name{prdnrmplot}
\alias{prdnrmplot}
\alias{prdnrmplot.tidal}
\alias{prdnrmplot.tidalmean}
\title{Plot combined predicted and normalized results from a tidal object}
\usage{
prdnrmplot(dat_in, ...)

\method{prdnrmplot}{tidal}(dat_in, tau = NULL, annuals = TRUE,
  logspace = TRUE, dt_rng = NULL, col_vec = NULL, lwd = 1, size = 2,
  alpha = 1, min_mo = 9, mo_strt = 10, pretty = TRUE, plot = TRUE,
  ...)

\method{prdnrmplot}{tidalmean}(dat_in, annuals = TRUE, logspace = TRUE,
  dt_rng = NULL, col_vec = NULL, lwd = 1, size = 2, alpha = 1,
  min_mo = 9, mo_strt = 10, pretty = TRUE, plot = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to \code{\link[ggplot2]{geom_line}}}

\item{tau}{numeric vector of quantiles to plot, defaults to all in object if not supplied}

\item{annuals}{logical indicating if plots are annual aggregations of results}

\item{logspace}{logical indicating if plots are in log space}

\item{dt_rng}{Optional chr string indicating the date range of the plot. Must be two values in the format 'YYYY-mm-dd' which is passed to \code{\link{as.Date}}.}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}}.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{lwd}{numeric value indicating width of lines}

\item{size}{numeric value indicating size of points}

\item{alpha}{numeric value indicating transparency of points or lines}

\item{min_mo}{numeric value from one to twelve indicating the minimum number of months with observations for averaging by years, applies only if \code{annuals = TRUE}.  See \code{\link{annual_agg}}.}

\item{mo_strt}{numeric indicating month to start aggregation years, defaults to October for USGS water year from October to September, applies only if \code{annuals = TRUE}.  See \code{\link{annual_agg}}.}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}

\item{plot}{logical if plot is returned, otherwise data used in the plot}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot combined predicted and normalized results from a tidal object to evaluate the influence of salinity or flow changes on the response variable. The plot is similar to that produced by \code{\link{fitplot}} except predicted values are shown as points and observed values are removed.
}
\examples{

## load a fitted tidal object
data(tidfit)

## plot using defaults
prdnrmplot(tidfit)

## get the same plot but use default ggplot settings
prdnrmplot(tidfit, pretty = FALSE)

## plot in log space
prdnrmplot(tidfit, logspace = TRUE)

## plot specific quantiles
prdnrmplot(tidfit, tau = c(0.1, 0.9))

## plot the normalized predictions
prdnrmplot(tidfit, predicted = FALSE)

## plot as monthly values
prdnrmplot(tidfit, annuals = FALSE) 

## format the x-axis is using annual aggregations
library(ggplot2)

prdnrmplot(tidfit, annual = TRUE) + 
 scale_x_date(limits = as.Date(c('2000-01-01', '2012-01-01')))

## modify the plot as needed using ggplot scales, etc.
prdnrmplot(tidfit, pretty = FALSE, linetype = 'dashed') + 
 theme_classic() + 
 scale_y_continuous(
   'Chlorophyll', 
   limits = c(0, 50)
   ) +
 scale_colour_manual( 
   '', 
   labels = c('lo', 'md', 'hi'), 
   values = c('red', 'green', 'blue'), 
   guide = guide_legend(reverse = TRUE)
   ) 
 
 ## plot a tidalmean object
 data(tidfitmean)
 
 prdnrmplot(tidfitmean)
 
}
\seealso{
\code{\link{fitplot}}, \code{\link{sliceplot}}
}

