% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrtdstrnd.R
\name{wrtdstrnd}
\alias{wrtdstrnd}
\alias{wrtdstrnd.default}
\alias{wrtdstrnd.tidal}
\alias{wrtdstrnd.tidalmean}
\title{Get WRTDS trends}
\usage{
wrtdstrnd(dat_in, ...)

\method{wrtdstrnd}{default}(dat_in, mobrks, yrbrks, molabs, yrlabs,
  aves = FALSE, mo_strt = 10, min_mo = 9, ...)

\method{wrtdstrnd}{tidal}(dat_in, mobrks, yrbrks, molabs, yrlabs,
  tau = NULL, aves = FALSE, mo_strt = 10, min_mo = 9, ...)

\method{wrtdstrnd}{tidalmean}(dat_in, mobrks, yrbrks, molabs, yrlabs,
  aves = FALSE, mo_strt = 10, min_mo = 9, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object which must already have fitted model data}

\item{...}{methods passed to or from other methods}

\item{mobrks}{list of month groupings where each month is an integer from 1 to 12, see examples}

\item{yrbrks}{numeric vector of breaks for years, see examples}

\item{molabs}{character vector of names for month breaks, see examples}

\item{yrlabs}{character vector of names for year breaks, see examples}

\item{aves}{logical if averages within each period are also returned}

\item{mo_strt}{numeric indicating month to start aggregation years for annual trends, defaults to October for USGS water year from October to September, passed to \code{\link{annual_agg}}}

\item{min_mo}{numeric value from one to twelve indicating the minimum number of months with observations for averaging by years, passed to \code{\link{annual_agg}}}

\item{tau}{numeric vector of quantile for estimating trends}
}
\value{
A \code{\link[base]{data.frame}} with summary trends for each grouping
}
\description{
Get WRTDS trends for annual and monthly groupings
}
\details{
Trends are reported as percent changes of annual averages from the beginning to the end of each period.  To reduce the effects of odd years at the beginning and end of each period, percent changes are based on an average of the first three and last three annual averages.  For example, percent changes for January throughout an an entire time series from 1980 to 2000 would be the change of the average from January in 1980-1982 to the average from January in 1998-2000.  Annual trends, e.g., percent changes from 1980-1986, 1987-1993, etc. do not average by the first and last three years in each grouping because the values are already based on annual averages as returned by \code{\link{annual_agg}}.  

Note that the default minimum number of months argument (\code{min_mo}) may not be appropriate for all cases.  Annual estimates should first be evaluated with \code{\link{prdnrmplot}} to verify that odd years with missing months are not driving results for the annual percent changes.  

Averages in each period can be returned if \code{aves = TRUE}.  These averages are based on annual averages within each period for congruency with the trend estimates.  

All trends are based on back-transformed, flow-normalized results. 

The user must supply the annual and monthly aggregation periods to the appropriate arguments. These are passed to \code{\link[base]{cut}} and are left-open, right-closed along the interval.
}
\examples{
## load a fitted model object
data(tidfit)
data(tidfitmean)

## get trends

# setup month, year categories
mobrks <- list(c(1, 2, 3), c(4, 5, 6), c(7, 8, 9), c(10, 11, 12))
yrbrks <- c(1973, 1985, 1994, 2003, 2012)
molabs <- c('JFM', 'AMJ', 'JAS', 'OND')
yrlabs <- c('1974-1985', '1986-1994', '1995-2003', '2004-2012')

wrtdstrnd(tidfit, mobrks, yrbrks, molabs, yrlabs)
wrtdstrnd(tidfitmean, mobrks, yrbrks, molabs, yrlabs)

# get averages in each period
wrtdstrnd(tidfit, mobrks, yrbrks, molabs, yrlabs, aves = TRUE)
}
