% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.crt2arm}
\alias{wp.crt2arm}
\title{Statistical Power Analysis for Cluster Randomized Trials with 2 Arms}
\usage{
wp.crt2arm(n = NULL, f = NULL, J = NULL, icc = NULL, power = NULL,
  alpha = 0.05, alternative = c("two.sided", "one.sided"))
}
\arguments{
\item{n}{Sample size. It is the number of individuals within each cluster.}

\item{f}{Effect size. It specifies either the main effect of treatment, or the mean difference between the treatment clusters and the control clusters.}

\item{J}{Number of clusters / sides. It tells how many clusters are considered in the study design. At least two clusters are required.}

\item{icc}{Intra-class correlation. ICC is calculated as the ratio of between-cluster variance to the total variance.
It quantifies the degree to which two randomly drawn observations within a cluster are correlated.}

\item{power}{Statistical power.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{alternative}{Type of the alternative hypothesis (\code{"two.sided"} or \code{"one.sided"}). The default is "two.sided". The option "one.sided" can be either "less" or "greater".}
}
\value{
An object of the power analysis.
}
\description{
Cluster randomized trials (CRT) are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a contral arm \cite{(Liu, 2013)}.
The data from CRT can be analyzed in a two-level hierachical linear model, where the indicator variable for treatment assignment is included in second level. If a study contains multiple treatments, then mutiple indicators will be used.
This function is for designs with 2 arms (i.e., a treatment and a control).
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
}
\examples{
\donttest{
#To calculate the statistical power given sample size and effect size:
wp.crt2arm(f = 0.6, n = 20, J = 10, icc = 0.1, alpha = 0.05, power = NULL)
#  Cluster randomized trials with 2 arms
#
#     J  n   f icc     power alpha
#    10 20 0.6 0.1 0.5901684  0.05
#
#  NOTE: n is the number of subjects per cluster.
#  URL: http://psychstat.org/crt2arm

#To generate a power curve given a sequence of sample sizes:
res <- wp.crt2arm(f = 0.6, n = seq(20,100,10), J = 10,
                       icc = 0.1, alpha = 0.05, power = NULL)
res
#  Cluster randomized trials with 2 arms
#
#     J   n   f icc     power alpha
#    10  20 0.6 0.1 0.5901684  0.05
#    10  30 0.6 0.1 0.6365313  0.05
#    10  40 0.6 0.1 0.6620030  0.05
#    10  50 0.6 0.1 0.6780525  0.05
#    10  60 0.6 0.1 0.6890755  0.05
#    10  70 0.6 0.1 0.6971076  0.05
#    10  80 0.6 0.1 0.7032181  0.05
#    10  90 0.6 0.1 0.7080217  0.05
#    10 100 0.6 0.1 0.7118967  0.05
#
#  NOTE: n is the number of subjects per cluster.
#  URL: http://psychstat.org/crt2arm

#To plot the power curve:
plot(res) 

#To calculate the required sample size given power and effect size:
wp.crt2arm(f = 0.8, n = NULL, J = 10,
                 icc = 0.1, alpha = 0.05, power = 0.8)
#  Cluster randomized trials with 2 arms
#
#     J        n   f icc power alpha
#    10 16.02558 0.8 0.1   0.8  0.05
#
#  NOTE: n is the number of subjects per cluster.
#  URL: http://psychstat.org/crt2arm
}

}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
