% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{nuniroot}
\alias{nuniroot}
\title{Solve A Single Equation}
\usage{
nuniroot(f, interval, maxlength = 100)
}
\arguments{
\item{f}{Function for which the root is sought.}

\item{interval}{A vector containing the end-points of the interval to be searched for the root.}

\item{maxlength}{The number of vaulue points in the interval to be searched. It is 100 by default.}
}
\value{
A list with at least four components: root and f.root give the location of the root and the value of the function evaluated at that point.
iter and estim.prec give the number of iterations used and an approximate estimated precision for root.
(If the root occurs at one of the endpoints, the estimated precision is NA.)
}
\description{
The function searches in an interval for a root (i.e., zero) of the function f with respect to its first argument.
The argument interval is for the input of x, the corresponding outcome interval will be used as the interval to be searched in.
}
\examples{
\donttest{
f <- function(x) 1+x-0.5*x^2
interval <- c(-3,6)
nuniroot(f,interval)
}

}
