% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mediation}
\alias{wp.mediation}
\title{Statistical Power Analysis for Simple Mediation}
\usage{
wp.mediation(n = NULL, power = NULL, a = 0.5, b = 0.5, varx = 1,
  vary = 1, varm = 1, alpha = 0.05, interval = NULL)
}
\arguments{
\item{n}{Sample size.}

\item{power}{Statistical power.}

\item{a}{Coefficient from x to m. The default value is 0.5.}

\item{b}{Coefficient from m to y. The default value is 0.5.}

\item{varx}{Variance of x. The default value is 1.}

\item{vary}{Variance of y. The default value is 1.}

\item{varm}{Variance of m. The default value is 1.}

\item{alpha}{significance level chosen for the test. It equals 0.05 by default.}
\item{interval}{A vector containing the end-points of the interval to be searched for the root.}

}
\value{
An object of the power analysis.
}
\description{
This function is for mediation models. Mediation models can be used to investigate the underlying mechanisms related to why an input variable x influences an output variable y (e.g., \cite{Hayes, 2013; MacKinnon, 2008}).
The mediation effect is calculated as \cite{a*b},
where \cite{a} is the path coefficent from the predictor x to the mediator m,
and \cite{b} is the path coefficent from the mediator m to the outcome variable y.
Sobel test statistic \cite{(Sobel, 1982)} is used to test whether the mediation effect is significantly different from zero.
}
\examples{
\donttest{
#To calculate the statistical power given sample size and effect size:
wp.mediation(n = 100, power = NULL, a = 0.5, b = 0.5,
                  varx = 1, vary = 1, varm = 1, alpha = 0.05)
#    Power for simple mediation
#
#        n     power   a   b varx varm vary alpha
#      100 0.9337271 0.5 0.5    1    1    1  0.05
#  
#    URL: http://psychstat.org/mediation

#To generate a power curve given a sequence of sample sizes:
res <- wp.mediation(n = seq(50,100,5), power = NULL, a = 0.5, b = 0.5,
                            varx = 1, vary = 1, varm = 1, alpha = 0.05)
res
#    Power for simple mediation
#  
#        n     power   a   b varx varm vary alpha
#       50 0.6877704 0.5 0.5    1    1    1  0.05
#       55 0.7287681 0.5 0.5    1    1    1  0.05
#       60 0.7652593 0.5 0.5    1    1    1  0.05
#       65 0.7975459 0.5 0.5    1    1    1  0.05
#       70 0.8259584 0.5 0.5    1    1    1  0.05
#       75 0.8508388 0.5 0.5    1    1    1  0.05
#       80 0.8725282 0.5 0.5    1    1    1  0.05
#       85 0.8913577 0.5 0.5    1    1    1  0.05
#       90 0.9076417 0.5 0.5    1    1    1  0.05
#       95 0.9216744 0.5 0.5    1    1    1  0.05
#      100 0.9337271 0.5 0.5    1    1    1  0.05
#  
#    URL: http://psychstat.org/mediation

#To plot the power curve:
plot(res)

#To calculate the required sample size given power and effect size:
wp.mediation(n = NULL, power = 0.9, a = 0.5, b = 0.5,
                varx = 1, vary = 1, varm = 1, alpha = 0.05)
#    Power for simple mediation
#
#             n power   a   b varx varm vary alpha
#      87.56182   0.9 0.5 0.5    1    1    1  0.05
#  
#    URL: http://psychstat.org/mediation

#To calculate the minimum detectable effect size of one coefficent given power and sample size:
wp.mediation(n = 100, power = 0.9, a = NULL, b = 0.5,
               varx = 1, vary = 1, varm = 1, alpha = 0.05)
#    Power for simple mediation
#  
#                     n power         a   b varx varm vary alpha
#      100   0.9 0.7335197 0.5    1    1    1  0.05
#  
#    URL: http://psychstat.org/mediation
}

}
\references{
Hayes, A. F. (2013). Introduction to mediation, moderation, and conditional process analysis: A regression-based approach. Guilford Press.

MacKinnon, D. P. (2008). Introduction to statistical mediation analysis. Routledge.

Sobel, M. E. (1982). Asymptotic confidence intervals for indirect effects in structural equation models. Sociological methodology, 13, 290-312.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
