% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.sem.chisq}
\alias{wp.sem.chisq}
\title{Statistical Power Analysis for Structural Equation Modeling based on Chi-Squared Test}
\usage{
wp.sem.chisq(n = NULL, df = NULL, effect = NULL, power = NULL,
  alpha = 0.05)
}
\arguments{
\item{n}{Sample size.}

\item{df}{Degrees of freedom. The degrees of freedom of the chi-squared test.}

\item{effect}{Effect size. It specifies the population misfit of a SEM model, which is the difference between two SEM models: a full model (Mf) and a reduced model (Mr).
A convienient way to get the effect size is to fit the reduced model using SEM software such R package 'lavaan' \cite{(Rossel, 2012)}.
Then the effect size is calculated as the chi-squared statistics dividing by the sample size.}

\item{power}{Statistical power.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}
}
\value{
An object of the power analysis.
}
\description{
Structural equation modeling (SEM) is a multivariate technique used to analyze relationships among observed and latent variables.
It can be viewed as a combination of factor analysis and multivariate regression analysis.
Two methods are widely used in power analysis for SEM. One is based on the likelihood ratio test proposed by \cite{Satorra and Saris (1985)}.
The other is based on RMSEA proposed by \cite{MacCallum et al. (1996)}. 
This function is for SEM power analysis based on the likelihood ratio test.
}
\examples{
#To calculate the statistical power given sample size and effect size:
wp.sem.chisq(n = 100, df = 4, effect = 0.054, power = NULL, alpha = 0.05)
#    Power for SEM (Satorra & Saris, 1985)
#  
#        n df effect     power alpha
#      100  4  0.054 0.4221152  0.05
#  
#    URL: http://psychstat.org/semchisq

#To generate a power curve given a sequence of sample sizes:
res <- wp.sem.chisq(n = seq(100,600,100), df = 4,
           effect = 0.054, power = NULL, alpha = 0.05)
res
#    Power for SEM (Satorra & Saris, 1985)
#  
#        n df effect     power alpha
#      100  4  0.054 0.4221152  0.05
#      200  4  0.054 0.7510630  0.05
#      300  4  0.054 0.9145660  0.05
#      400  4  0.054 0.9750481  0.05
#      500  4  0.054 0.9935453  0.05
#      600  4  0.054 0.9984820  0.05
#  
#    URL: http://psychstat.org/semchisq

#To plot the power curve:
plot(res) 

#To generate a power curve given a sequence of alphas:
res <- wp.sem.chisq(n = 100, df = 4, effect = 0.054, power = NULL,
                            alpha = c(0.001, 0.005, 0.01, 0.025, 0.05))
res
#    Power for SEM (Satorra & Saris, 1985)
#  
#        n df effect      power alpha
#      100  4  0.054 0.06539478 0.001
#      100  4  0.054 0.14952768 0.005
#      100  4  0.054 0.20867087 0.010
#      100  4  0.054 0.31584011 0.025
#      100  4  0.054 0.42211515 0.050
#  
#    URL: http://psychstat.org/semchisq

#To calculate the required sample size given power and effect size:
wp.sem.chisq(n = NULL, df = 4, effect = 0.054, power = 0.8, alpha = 0.05)
#  Power for SEM (Satorra & Saris, 1985)
#
#           n df effect power alpha
#    222.0238  4  0.054   0.8  0.05
#
#  URL: http://psychstat.org/semchisq

#To calculate the minimum detectable effect size of one coefficent given power and sample size:
wp.sem.chisq(n = 100, df = 4, effect = NULL, power = 0.8, alpha = 0.05)
#    Power for SEM (Satorra & Saris, 1985)
#  
#        n df    effect power alpha
#      100  4 0.1205597   0.8  0.05
#  
#    URL: http://psychstat.org/semchisq
}
\references{
Satorra, A., & Saris, W. E. (1985). Power of the likelihood ratio test in covariance structure analysis. Psychometrika, 50(1), 83-90.

Rossel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Retrieved from http://users. ugent. be/~ yrosseel/lavaan/lavaanIntroduction. 

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
