\name{mlefit}
\alias{mlefit}

\title{Maximum likelihood regression on Weibull and Lognormal distributions}

\description{
 Maximum likelihood regression on weibull and lognormal distributions
}

\usage{
mlefit(x, dist="weibull", npar = 2, debias="none", optcontrol=NULL)
}

\arguments{
  \item{x}{A dataframe such as generated by mleframe with column names 'left', 'right' and optionally 'qty'.
    Exact failure data (occurrences) have same time entered in both 'left' and 'right' columns.
	Suspension data has last known life[time] entered in 'left' column and -1 entered in 'right' column.
	The left(early) interval bound for left-censored data must be entered as zero. (NA is not accepted).
  }
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default),"lognormal",
   "weibull3p" and "lognormal3p".
  }
  \item{npar}{An optional argument for specifying 3p optimization. Priority is given to any suffix to the distribution name.}
  \item{debias}{An optional string argument indicating the adjustment to be applied to the shape or standard deviation
  parameter of the fitted data. Adjustments recognized are: "rba" (default), "mean", and "hrbu" (for hirose-ross beta unbias). Any entry for debias
  with the lognormal distribution will be processed as "rba" with a warning if it was not clearly specified.
  }
  \item{optcontrol}{An optional list of arguments for control of the MLE optimization.  The strict naming convention for the list items are:
  'vstart', a vector holding starting estimate for parameters in the order used by the underlying R distribution [CAUTION: for weibull
  the order of parameters is (shape, scope)], 'limit', the convergence limit, 'maxit', the maximum number of interations permitted in
  the optimization, and 'listout' a logical indicating whether output should list both the fit and the optimization progress as a dataframe.
  }  
}

\value{
Returns a named vector with parameters of the distribution fit and goodness of fit in terms of log likelihood.
}

\details{
The negative log-likelihood is minimized by the Nelder-Meade, simplex, algorithm.  This algorithm requires a reasonable starting point
for the estimate.  Such a reasonable estimate is attempted by default, but in some cases this may be inadequate for proper function.
the optcontrol argument has been provided to give debug developers a means of altering and examining the progress of the optimization.
}

\references{
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York

  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition" 
  
  John I. McCool, (2012) "Using the Weibull Distribution: Reliability, Modeling and Inference"
  
  Marie Laure Delignette-Muller, Christophe Dutang (2015). "fitdistrplus: An R Package for Fitting Distributions".
  Journal of Statistical Software, 64(4), 1-34. URL http://www.jstatsoft.org/v64/i04/.
}

\examples{
failures<-c(90,96,30,49,82)
suspensions<-c(100,45,10)
weibull_fit<-mlefit(mleframe(failures,suspensions))
}

\keyword{ regression reliability }