% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_chat.R
\name{summarize_chat}
\alias{summarize_chat}
\title{Basic 'WhatsApp' chat log Statistics}
\usage{
summarize_chat(data, exclude_sm = FALSE)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the descriptive statistics. Default is FALSE.}
}
\value{
A list containing: \cr

     1) The number of messages in the chat \cr
     2) The number of tokens in the chat  \cr
     3) The number of participants in the chat  \cr
     4) The date of the first message\cr
     6) The date of the last message\cr
     7) The total duration of the chat \cr
     8) The number of system messages in the chat \cr
     9) The number of emoji in the chat \cr
     10) The number of smilies in the chat \cr
     11) The number of links in the chat\cr
     12) The number of media in the chat\cr
     12) The number of locations in the chat\cr
}
\description{
Creates a list of basic information about a single 'WhatsApp' chat log
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
summarize_chat(data)
}
