% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whitestripe_ind.R
\name{whitestripe_ind_to_mask}
\alias{whitestripe_ind_to_mask}
\alias{whitemask}
\title{WhiteStripe Indices to Mask}
\usage{
whitestripe_ind_to_mask(img, indices, writeimg = FALSE, ...)
}
\arguments{
\item{img}{Array or class nifti that is corresponds to dimensions of the images the
indices were generated from}

\item{indices}{indices from \code{\link{whitestripe}}}

\item{writeimg}{logical to write image or not}

\item{...}{arguments to passed to \code{\link{writeNIfTI}} for writing image}
}
\value{
Class of array or nifti depending on \code{img} input
}
\description{
Uses WhiteStripe indices to create image mask
}
\examples{
\donttest{
lib.loc = tempdir()
if (download_img_data(lib.loc = lib.loc)){
  t1 = oro.nifti::readNIfTI(system.file("T1Strip.nii.gz",
                                        package="WhiteStripe",
                                        lib.loc = lib.loc))
  t2 = oro.nifti::readNIfTI(system.file("T2Strip.nii.gz",
                                        package="WhiteStripe",
                                        lib.loc = lib.loc))
  ind = whitestripe_hybrid(t1, t2)
  mask = whitestripe_ind_to_mask(t1, ind$whitestripe.ind)
  oro.nifti::orthographic(mask)
}
}
}
\seealso{
whitestripe, whitestripe_hybrid
}
\keyword{hybrid}
\keyword{whitestripe}
