% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/contribs.R
\name{contribs}
\alias{contribs}
\title{lists contributions of a specific wikipedia page}
\usage{
contribs(page = NULL, domain = "en", rvprop = "user|userid|timestamp")
}
\arguments{
\item{page}{numeric identifier or character title of the specific wikipedia page}

\item{domain}{a character value specifying the language of the wikipedia page.The default value is "en" for "english language".}

\item{rvprop}{Which properties to get for each revision (separate with '|'):
\itemize{
\item  ids: the ID of the revision
\item  flags: revision flags (minor)
\item  timestamp: the timestamp of the revision, i.e. day and time
\item  user: user that made the revision
\item  userid: user id of revision creator
\item  size: length (bytes) of the revision
\item  sha1: SHA-1 (base 16) of the revision
\item  contentmodel: content model id
\item  comment: comment by the user for revision
\item  parsedcomment: parsed comment by the user for the revision
\item  content: text of the revision
\item  tags: tags for the revision
}
Default: user|userid|timestamp}
}
\value{
an object of class \code{contribsClass}:
\itemize{
\item{\code{call}}{ the command line}
\item{\code{page} }{ title and identification number of the Wikipedia page}
\item{\code{contribs}}{ a data frame containing asked properties of the contribs, by default : user, userid, timestamp.
If the user does not exist or has no contribution, this item is not created.}
\item{\code{testWikiPage}}{ a list of four elements,
   \itemize{
   \item{\code{takeOnlyFirst}}{ a boolean indicating if the class of \code{page} parameter is invalid,
             for example vector, list, matrix..., and in that case, only the first element is considered.}
   \item{\code{redirPage}}{ title of the redirected page. This item is NULL if the page is not redirected.}
   \item{\code{test}}{ an integer with value:
     \itemize{
     \item{4}{ for invalid domain,}
     \item{3}{ for an empty parameter page,}
     \item{2}{ when Wikipedia does not have an article with this exact name,}
     \item{1}{ for ambiguous page, direct or redirect,}
     \item{0}{ for valid an unambiguous page, direct or redirect. }
     }
   }
   \item{\code{warnMessage}}{ is a vector of warning messages.}
   }
}
}
}
\description{
provide the list of the contributions of a wikipedia page: discussions for Talk pages, or revisions for Subject pages.
}
\details{
This function uses the API query syntax: "prop=revisions". For more details, see \url{https://www.mediawiki.org/wiki/API:Backlinks}
If the page is ambiguous, the contributions correspond to the modification on this ambiguous page, not on the possible linked pages.
If the user is anonymous, the user in the output corresponds to the IP address, and the userid is zero.
}
\examples{
\dontrun{
## numeric page identifier as parameter
contribs(domain = "fr", page = 108907)

## title page as parameter
contribs(domain ="en", page = "Wikipedia")
}
}
\author{
Avner Bar-Hen, Louise Baschet, Francois-Xavier Jollois, Jeremie Riou
}
\seealso{
print.contribsClass userInfo
}

