#' Estimates Economic Variables for Word-of-Mouth-Campaigns
#' 
#' This packages provides classes, methods and functions for modeling Word-of-Mouth-campaigns.
#' General model assumptions are: 
#' \itemize{
#' \item monopoly market
#' \item no variable costs
#' \item network is the mean-field case of percolation
#' \item only those persons who bought a product will forward information about it
#' }
#' 
#' \tabular{ll}{ Package: \tab WordOfMouth\cr Type: \tab Package\cr Version: 
#' \tab 1.0.0\cr Date: \tab 2020-03-27\cr License: \tab GPL-3\cr Depends: \tab
#' R (>= 3.0.1), methods\cr }
#' 
#' @name WordOfMouth-package
#' @aliases WordOfMouth-package WordOfMouth
#' @docType package
#' @author Michael Scholz \email{michael.scholz@@th-deg.de}
#' @author Thomas Woehner \email{Thomas.Woehner@@eah-jena.de}
#' @author Ralf Peters \email{ralf.peters@@wiwi.uni-halle.de}
#' 
#' @import methods LambertW
#' @importFrom stats optim
#' @keywords Word-of-Mouth 
#' 
NULL