% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Fields.R
\name{fields_info}
\alias{fields_info}
\title{Return details about form's fields}
\source{
Idea borrowed from \url{http://www.exegetic.biz/blog/2014/06/concatenating-a-list-of-data-frames}
}
\usage{
fields_info(wufoo_name = auth_name(NULL), formIdentifier = NULL,
  showRequestURL = FALSE)
}
\arguments{
\item{wufoo_name}{- User's Name. Default: \code{\link{auth_name}}}

\item{formIdentifier}{- this will give you information about just one form. The call without
the "formIdentifier" will return all forms.}

\item{showRequestURL}{- use only for DEBUG purposes}
}
\value{
Title - The title is the friendly name you gave the field when creating your form. For
example, if you were building a table with the API, the Title would be a column header.

Type - The Type represents a Wufoo field type. A listing of the these types can be found
in the Field Type section of this documentation.

ID - This is the unique reference ID for your field. There will be one corresponding ID
for each Entry in return value of the the Entries API.

IsRequired - This value can be one or zero, representing whether or not the field has
been marked required in the Form Builder.

OtherField - This value is true or false and is only set if the field has choices. Only
Multiple-Choice fields have the option of an Other field. When a Multiple-Choice field is marked
as HasOtherField, the last choice is the Other field.
}
\description{
The Fields API describes the hierarchy of your data. At the heart of this API is the
listing of FieldId values. Each FieldId corresponds to a value in the Entries API.
}
\note{
This function returns 2 data frames. One containing only default fields, another one containing
subfields as described \url{http://help.wufoo.com/articles/en_US/SurveyMonkeyArticleType/The-Fields-API#Fancypants}.
"These include name, shortname, checkbox, address, and likert."
}
\examples{
fields_info(formIdentifier = "z5kqx7h1gtvg4g", showRequestURL = TRUE)
fields_info(formIdentifier = "z5kqx7h1gtvg4g")
}

