% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xPrioritiser.r
\name{xPrioritiser}
\alias{xPrioritiser}
\title{Function to do prioritisation through random walk techniques}
\usage{
xPrioritiser(seeds, g, normalise = c("laplacian", "row", "column",
"none"),
restart = 0.75, normalise.affinity.matrix = c("none", "quantile"),
parallel = TRUE, multicores = NULL, verbose = T)
}
\arguments{
\item{seeds}{a named input vector containing a list of seed nodes. For
this named vector, the element names are seed/node names (e.g. gene
symbols), the element (non-zero) values used to weight the relative
importance of seeds. Alternatively, it can be a matrix or data frame
with two columns: 1st column for seed/node names, 2nd column for the
weight values}

\item{g}{an object of class "igraph" to represent network. It can be a
weighted graph with the node attribute 'weight'}

\item{normalise}{the way to normalise the adjacency matrix of the input
graph. It can be 'laplacian' for laplacian normalisation, 'row' for
row-wise normalisation, 'column' for column-wise normalisation, or
'none'}

\item{restart}{the restart probability used for Random Walk with
Restart (RWR). The restart probability takes the value from 0 to 1,
controlling the range from the starting nodes/seeds that the walker
will explore. The higher the value, the more likely the walker is to
visit the nodes centered on the starting nodes. At the extreme when the
restart probability is zero, the walker moves freely to the neighbors
at each step without restarting from seeds, i.e., following a random
walk (RW)}

\item{normalise.affinity.matrix}{the way to normalise the output
affinity matrix. It can be 'none' for no normalisation, 'quantile' for
quantile normalisation to ensure that columns (if multiple) of the
output affinity matrix have the same quantiles}

\item{parallel}{logical to indicate whether parallel computation with
multicores is used. By default, it sets to true, but not necessarily
does so. Partly because parallel backends available will be
system-specific (now only Linux or Mac OS). Also, it will depend on
whether these two packages "foreach" and "doMC" have been installed. It
can be installed via:
\code{source("http://bioconductor.org/biocLite.R");
biocLite(c("foreach","doMC"))}. If not yet installed, this option will
be disabled}

\item{multicores}{an integer to specify how many cores will be
registered as the multicore parallel backend to the 'foreach' package.
If NULL, it will use a half of cores available in a user's computer.
This option only works when parallel computation is enabled}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "pNode", a list with following components:
\itemize{
\item{\code{priority}: a matrix of nNode X 4 containing node priority
information, where nNode is the number of nodes in the input graph, and
the 4 columns are "name" (node names), "seed" (1 for seeds, 0 for
non-seeds), "weight" (weight values), "priority" (the priority scores
that are rescaled to the range [0,1]), "rank" (ranks of the priority
scores)}
\item{\code{g}: an input "igraph" object}
\item{\code{call}: the call that produced this result}
}
}
\description{
\code{xPrioritiser} is supposed to prioritise nodes given an input
graph and a list of seed nodes. It implements Random Walk with Restart
(RWR) and calculates the affinity score of all nodes in the graph to
the seeds. The priority score is the affinity score. Parallel computing
is also supported for Linux or Mac operating systems. It returns an
object of class "pNode".
}
\note{
The input graph will treat as an unweighted graph if there is no
'weight' edge attribute associated with
}
\examples{
\dontrun{
# Load the library
library(XGR)
library(igraph)
library(dnet)

# a) provide the input nodes/genes with the significance info
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg')
sig <- rbeta(500, shape1=0.5, shape2=1)
data <- data.frame(symbols=org.Hs.eg$gene_info$Symbol[1:500], sig)

# b) provide the network
g <- xRDataLoader(RData.customised='org.Hs.string')

# c) perform priority analysis
pNode <- xPrioritiser(seeds=data, g=g, restart=0.75)
}
}
\seealso{
\code{\link{xRDataLoader}}, \code{\link{xPrioritiserSNPs}},
\code{\link{xPrioritiserGenes}}, \code{\link{xPrioritiserPathways}}
}

