% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xBiheatmap.r
\name{xBiheatmap}
\alias{xBiheatmap}
\title{Function to visualise bipartitle graph communities using heatmap}
\usage{
xBiheatmap(g, which.communites = NULL, colormap = "spectral",
ncolors = 64, zlim = NULL, barwidth = 0.3, barheight = NULL,
nbin = 64, legend.title = "", x.rotate = 60, x.text.size = 3,
y.text.size = 3, legend.text.size = 4, legend.title.size = 6,
shape = 19, size = 0.5, plot.margin = unit(c(5.5, 5.5, 5.5, 5.5),
"pt"),
font.family = "sans", na.color = "transparent",
intercept.color = "grey95", intercept.size = 0.3)
}
\arguments{
\item{g}{an object of class "igraph" for a bipartitel graph with node
attributes 'type', 'community' and 'contribution'}

\item{which.communites}{a vector specifying which communites are
visualised. If NULL (by default), all communites will be used}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted, defaulting to the range of the finite values of displayed
matrix}

\item{barwidth}{the width of the colorbar. Default value is
'legend.key.width' or 'legend.key.size' in 'theme' or theme}

\item{barheight}{the height of the colorbar. Default value is
'legend.key.height' or 'legend.key.size' in 'theme' or theme}

\item{nbin}{the number of bins for drawing colorbar}

\item{legend.title}{the title of the colorbar. By default, it is ''}

\item{x.rotate}{the angle to rotate the x tick labelings. By default,
it is 60}

\item{x.text.size}{the text size of the x tick labelings. By default,
it is 6}

\item{y.text.size}{the text size of the y tick labelings. By default,
it is 6}

\item{legend.text.size}{the text size of the legend tick labelings. By
default, it is 5}

\item{legend.title.size}{the text size of the legend titles. By
default, it is 6}

\item{shape}{the number specifying the shape. By default, it is 19}

\item{size}{the number specifying the shape size. By default, it is 2}

\item{plot.margin}{the margin (t, r, b, l) around plot. By default, it
is unit(c(5.5,5.5,5.5,5.5),"pt")}

\item{font.family}{the font family for texts}

\item{na.color}{the color for NAs. By default, it is 'grey80'}

\item{intercept.color}{intercept color}

\item{intercept.size}{intercept size}
}
\value{
a gpplot2 object
}
\description{
\code{xBiheatmap} is supposed to visualise bipartitle graph communities
using heatmap.
}
\examples{
# 1) generate a random bipartite graph
set.seed(123)
g <- sample_bipartite(100, 50, p=0.1)
V(g)$name <- V(g)

\dontrun{
# 2) obtain its community
ig <- xBigraph(g)

# 3) heatmap of its community
gp <- xBiheatmap(ig)
}
}
\seealso{
\code{\link{xBigraph}}, \code{\link{xHeatmap}}
}
