% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xCorrelation.r
\name{xCorrelation}
\alias{xCorrelation}
\title{Function to calculate and visualise correlation}
\usage{
xCorrelation(df, list_vec, method = c("pearson", "spearman"),
p.type = c("nominal", "empirical"), seed = 825, nperm = 2000,
p.adjust.method = c("BH", "BY", "bonferroni", "holm", "hochberg",
"hommel"),
plot = FALSE, plot.smooth = c(NA, "lm", "loess"))
}
\arguments{
\item{df}{a data frame with two columns ('name' and 'value')}

\item{list_vec}{a named vector containing numeric values. Alternatively
it can be a list of named vectors}

\item{method}{the method used to calcualte correlation. It can be
'pearson' for Pearson's correlation or 'spearman' for Spearman rank
correlation}

\item{p.type}{the type of the p-value calcualted. It can be 'nominal'
for nominal p-value or 'empirical' for empirical p-value}

\item{seed}{an integer specifying the seed}

\item{nperm}{the number of random permutations}

\item{p.adjust.method}{the method used to adjust p-values. It can be
one of "BH", "BY", "bonferroni", "holm", "hochberg" and "hommel". The
first two methods "BH" (widely used) and "BY" control the false
discovery rate (FDR: the expected proportion of false discoveries
amongst the rejected hypotheses); the last four methods "bonferroni",
"holm", "hochberg" and "hommel" are designed to give strong control of
the family-wise error rate (FWER). Notes: FDR is a less stringent
condition than FWER}

\item{plot}{logical to indicate whether scatter plot is drawn}

\item{plot.smooth}{the smooth method for the scatter plot. It can be NA
(depending on correlation type), "lm" for the linear line or 'loess'
for the loess curve}
}
\value{
a list with three componets:
\itemize{
\item{\code{df_summary}: a data frame of n x 5, where n is the number
of named vectors, and the 5 columns are "name", "num" (i.e. number of
data points used for calculation), "cor" (i.e. correlation), "pval"
(i.e. p-value), "fdr"}
\item{\code{ls_gp_curve}: NULL if the plot is not drawn; otherwise, a
list of 'ggplot' objects for scatter plot together with an estimated
curve}
\item{\code{ls_gp_pdf}: NULL if the plot is not drawn; otherwise, a
list of 'ggplot' objects for pdf plot for null distribution of
correlation together with a vertical line for observed correlation}
}
}
\description{
\code{xCorrelation} is supposed to calculate and visualise correlation
between a data frame and a named vector (or a list of named vectors).
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"
\dontrun{
# a) provide the seed nodes/genes with the weight info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get genes within 500kb away from AS GWAS lead SNPs
seeds.genes <- ImmunoBase$AS$genes_variants
## seeds weighted according to distance away from lead SNPs
data <- 1- seeds.genes/500000

# b) prepare a data frame
df <- data.frame(name=names(data), value=data, stringsAsFactors=FALSE)

# c) do correlation
ls_res <- xCorrelation(df, data, method="pearson", p.type="empirical",
nperm=2000, plot=TRUE)
}
}
\seealso{
\code{\link{xCorrelation}}
}
