% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGR2xGeneScores.r
\name{xGR2xGeneScores}
\alias{xGR2xGeneScores}
\title{Function to identify likely modulated seed genes from an input list of genomic regions together with the significance level given the crosslink info}
\usage{
xGR2xGeneScores(data, significance.threshold = NULL, score.cap = NULL,
build.conversion = c(NA, "hg38.to.hg19", "hg18.to.hg19"),
crosslink = c("genehancer", "PCHiC_combined", "GTEx_V6p_combined",
"nearby"), crosslink.customised = NULL, cdf.function = c("original",
"empirical"), scoring.scheme = c("max", "sum", "sequential"),
nearby.distance.max = 50000, nearby.decay.kernel = c("rapid", "slow",
"linear", "constant"), nearby.decay.exponent = 2, verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{a named input vector containing the sinificance level for
genomic regions (GR). For this named vector, the element names are GR,
in the format of 'chrN:start-end', where N is either 1-22 or X, start
(or end) is genomic positional number; for example, 'chr1:13-20'. The
element values for the significance level (measured as p-value or fdr).
Alternatively, it can be a matrix or data frame with two columns: 1st
column for GR, 2nd column for the significance level.}

\item{significance.threshold}{the given significance threshold. By
default, it is set to NULL, meaning there is no constraint on the
significance level when transforming the significance level of GR into
scores. If given, those GR below this are considered significant and
thus scored positively. Instead, those above this are considered
insignificant and thus receive no score}

\item{score.cap}{the maximum score being capped. By default, it is set
to NULL, meaning that no capping is applied}

\item{build.conversion}{the conversion from one genome build to
another. The conversions supported are "hg38.to.hg19" and
"hg18.to.hg19". By default it is NA (no need to do so)}

\item{crosslink}{the built-in crosslink info with a score quantifying
the link of a GR to a gene. See \code{\link{xGR2xGenes}} for details}

\item{crosslink.customised}{the crosslink info with a score quantifying
the link of a GR to a gene. A user-input matrix or data frame with 4
columns: 1st column for genomic regions (formatted as "chr:start-end",
genome build 19), 2nd column for Genes, 3rd for crosslink score
(crosslinking a genomic region to a gene, such as -log10 significance
level), and 4th for contexts (optional; if nor provided, it will be
added as 'C'). Alternatively, it can be a file containing these 4
columns. Required, otherwise it will return NULL}

\item{cdf.function}{a character specifying how to transform the input
crosslink score. It can be one of 'original' (no such transformation),
and 'empirical' for looking at empirical Cumulative Distribution
Function (cdf; as such it is converted into pvalue-like values [0,1])}

\item{scoring.scheme}{the method used to calculate seed gene scores
under a set of GR (also over Contexts if many). It can be one of "sum"
for adding up, "max" for the maximum, and "sequential" for the
sequential weighting. The sequential weighting is done via:
\eqn{\sum_{i=1}{\frac{R_{i}}{i}}}, where \eqn{R_{i}} is the
\eqn{i^{th}} rank (in a descreasing order)}

\item{nearby.distance.max}{the maximum distance between genes and GR.
Only those genes no far way from this distance will be considered as
seed genes. This parameter will influence the distance-component
weights calculated for nearby GR per gene}

\item{nearby.decay.kernel}{a character specifying a decay kernel
function. It can be one of 'slow' for slow decay, 'linear' for linear
decay, and 'rapid' for rapid decay. If no distance weight is used,
please select 'constant'}

\item{nearby.decay.exponent}{a numeric specifying a decay exponent. By
default, it sets to 2}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
an object of class "mSeed", a list with following components:
\itemize{
\item{\code{GR}: a matrix of nGR X 3 containing GR information, where
nGR is the number of GR, and the 3 columns are "GR" (genomic regions),
"Score" (the scores for GR calculated based on p-values taking into
account the given threshold of the significant level), "Pval" (the
input p-values for GR)}
\item{\code{Gene}: a matrix of nGene X 3 containing Gene information,
where nGene is the number of seed genes, and the 3 columns are "Gene"
(gene symbol), "Score" (the scores for seed genes), "Pval"
(p-value-like significance level transformed from gene scores)}
\item{\code{Link}: a matrix of nLink X 5 containing GR-Gene link
information, where nLink is the number of links, and the 5 columns are
"GR" (genomic regions), "Gene" (gene symbol), "Score" (the scores for
the link multiplied by the GR score), "Score_GR" (the scores for GR),
"Score_link" (the original scores for the link if cdf.function is
'original'; otherwise cdf based on the whole crosslink inputs)}
}
}
\description{
\code{xGR2xGeneScores} is supposed to identify likely modulated seed
genes from a list of genomic regions (GR) together with the
significance level (measured as p-values or fdr). To do so, it defines
seed genes and their scores given the crosslink info with a score
quantifying the link of a GR to a gene. It returns an object of class
"mSeed".
}
\note{
This function uses \code{\link{xGRscores}} and \code{\link{xGR2xGenes}}
to define and score seed genes from input genomic regions.
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"

# a) provide the seed SNPs with the significance info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
df <- as.data.frame(gr, row.names=NULL)
GR <- paste0(df$seqnames,':',df$start,'-',df$end)
data <- cbind(GR=GR, Sig=df$Pvalue)

# b) define and score seed geens
mSeed <- xGR2xGeneScores(data=data, crosslink="genehancer",
RData.location=RData.location)
}
}
\seealso{
\code{\link{xGRscores}}, \code{\link{xGR2xGenes}},
\code{\link{xSparseMatrix}}
}
