% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xBiproject.r
\name{xBiproject}
\alias{xBiproject}
\title{Function to obtain a projected graph from a bipartitle graph}
\usage{
xBiproject(g, verbose = TRUE)
}
\arguments{
\item{g}{an object of class "igraph" (or "graphNEL") for a bipartitel
graph with a 'type' node attribute}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
It returns an igraph object.
}
\description{
\code{xBiproject} is supposed to obtain a projected graph from a
bipartitle graph.
}
\note{
The input graph will has an equal weight if there is no 'weight' edge
attribute associated with
}
\examples{
# 1) generate a random bipartite graph
set.seed(123)
g <- sample_bipartite(100, 50, p=0.05)
V(g)$name <- V(g)

\dontrun{
# 2) obtain its projected graph
ig <- xBiproject(g)

# 3) estimate pairwise affiinity between nodes
mat <- xRWkernel(ig)
}
}
\seealso{
\code{\link{xBiproject}}
}
