% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichTreemap.r
\name{xEnrichTreemap}
\alias{xEnrichTreemap}
\title{Function to visualise enrichment results using a treemap}
\usage{
xEnrichTreemap(eTerm, top_num = 10, FDR.cutoff = 0.05, CI.one = T,
colormap = "spectral.top", ncolors = 64, zlim = NULL, barwidth = NULL,
barheight = 0.5, wrap.width = NULL, font.family = "sans", drop = F,
details = c("name", "name_FDR", "name_FDR_members"), caption = T,
treemap.grow = F, treemap.reflow = F, treemap.place = "topleft",
treemap.color = "black", treemap.fontface = "bold.italic",
treemap.min.size = 4)
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns (named as
'group','ontology','name','adjp','or','CIl','CIu','nOverlap','members')}

\item{top_num}{the number of the top terms (sorted according to OR). If
it is 'auto', only the significant terms (see below FDR.cutoff) will be
displayed}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{CI.one}{logical to indicate whether to allow the inclusion of one
in CI. By default, it is TURE (allowed)}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted, defaulting to the range of the -log10(FDR)}

\item{barwidth}{the width of the colorbar. Default value is
'legend.key.width' or 'legend.key.size' in 'theme' or theme}

\item{barheight}{the height of the colorbar. Default value is
'legend.key.height' or 'legend.key.size' in 'theme' or theme}

\item{wrap.width}{a positive integer specifying wrap width of name}

\item{font.family}{the font family for texts}

\item{drop}{logical to indicate whether all factor levels not used in
the data will automatically be dropped. If FALSE (by default), all
factor levels will be shown, regardless of whether or not they appear
in the data}

\item{details}{how to label. It can be one of 'name', 'name_FDR'
(FDR/OR also appended to the name), and 'name_FDR_members' (FDR/OR plus
members appended to the name; in this case, treemap.grow and
treemap.reflow is forced to be true)}

\item{caption}{logical to indicate whether the caption is shown on the
bottom-right}

\item{treemap.grow}{logical to indicate whether text will be grown as
well as shrunk to fill the box}

\item{treemap.reflow}{logical to indicate whether text will be reflowed
(wrapped) to better fit the box}

\item{treemap.place}{where inside the box to place the text. Default is
"centre"; other options are "bottom", "top", "topleft", "topright",
etc}

\item{treemap.color}{the color of the text}

\item{treemap.fontface}{the fontface of the text}

\item{treemap.min.size}{the minimum font size, in points. If provided,
text that would need to be shrunk below this size to fit the box will
not be drawn. Defaults to 4 pt}
}
\value{
an object of class "ggplot"
}
\description{
\code{xEnrichTreemap} is supposed to visualise enrichment results using
a treemap. The area is proportional to odds ratio, colored by the
significance level. It returns an object of class "ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"
library(treemapify)

# provide the input Genes of interest (eg 100 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg',
RData.location=RData.location)
set.seed(825)
data <- as.character(sample(org.Hs.eg$gene_info$Symbol, 100))
data

# optionally, provide the test background (if not provided, all human genes)
#background <- as.character(org.Hs.eg$gene_info$Symbol)

# 1) Gene-based enrichment analysis using REACTOME pathways
# perform enrichment analysis
eTerm <- xEnricherGenes(data, ontology="REACTOME",
RData.location=RData.location)
## forest plot of enrichment results
gp <- xEnrichTreemap(eTerm, top_num=20, FDR.cutoff=0.05,
treemap.reflow=F, treemap.place="topleft")

# 2) Gene-based enrichment analysis using ontologies (REACTOME and GOMF)
# perform enrichment analysis
ls_eTerm <- xEnricherGenesAdv(data, ontologies=c("REACTOME","GOMF"),
RData.location=RData.location)
## forest plot of enrichment results
gp <- xEnrichTreemap(ls_eTerm, FDR.cutoff=0.1)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xEnricherSNPs}},
\code{\link{xEnrichViewer}}
}
