% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichDotplot.r
\name{xEnrichDotplot}
\alias{xEnrichDotplot}
\title{Function to visualise enrichment results using dot-like plot}
\usage{
xEnrichDotplot(eTerm, FDR.cutoff = 0.05, colors = c("pink", "red"),
y.scale = c("normal", "log"), slim = NULL, size.range = c(0.5,
3.5), size.title = "Num of overlaps", label.top = "auto",
label.direction.y = c("left", "right", "none"), label.size = 2, ...)
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns (named as
'group','name','adjp','zscore','nOverlap')}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{colors}{a 2-element vector for color-coded points. By default, it
is c("pink","red"), responding to the insignificant and the
significant}

\item{y.scale}{how to transform the y scale. It can be "normal" for no
transformation, and "log" for log-based transformation}

\item{slim}{the minimum and maximum values for which sizes should be
plotted}

\item{size.range}{the range of actual node size}

\item{size.title}{a character specifying the title for node sizing. By
default it is 'Num of overlaps'}

\item{label.top}{the number of the top terms (sorted according to
adjp). Only the significant terms (see above FDR.cutoff) will be
labelled}

\item{label.direction.y}{how to align labels. It can be "none", "left"
(align labels on the left edge) or "right" (align labels on the right
edge). Only works for individual group}

\item{label.size}{the size of the labellings}

\item{...}{additional graphic parameters (such as size, color) used in
ggrepel::geom_text_repel to control labels}
}
\value{
an object of class "ggplot"
}
\description{
\code{xEnrichDotplot} is supposed to visualise enrichment results using
dot-like plot. It returns a ggplot2 object.
}
\note{
none
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

gp <- xEnrichDotplot(eTerm, label.top=10)
}
}
\seealso{
\code{\link{xEnrichDotplot}}
}
