/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.DataFormatOnlyCellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.HCellStyle;
import com.miraisolutions.xlconnect.SSCellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.XCellStyle;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workbook
extends Common {
    private static final Logger logger = Logger.getLogger("com.miraisolutions.xlconnect");
    private final org.apache.poi.ss.usermodel.Workbook workbook;
    private File excelFile;
    private StyleAction styleAction = StyleAction.XLCONNECT;
    private String styleNamePrefix = null;
    private String missingValue = null;
    private final Map<String, Map<String, CellStyle>> stylesMap = new HashMap<String, Map<String, CellStyle>>(10);
    private final Map<DataType, String> dataFormatMap = new HashMap<DataType, String>(DataType.values().length);
    private ErrorBehavior onErrorCell = ErrorBehavior.WARN;

    private Workbook(InputStream in) throws IOException, InvalidFormatException {
        this.workbook = WorkbookFactory.create((InputStream)in);
        this.excelFile = null;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private Workbook(File excelFile) throws FileNotFoundException, IOException, InvalidFormatException {
        this(new FileInputStream(excelFile));
        this.excelFile = excelFile;
    }

    private Workbook(File excelFile, SpreadsheetVersion version) {
        switch (version) {
            case EXCEL97: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case EXCEL2007: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            default: {
                logger.log(Level.SEVERE, "File '" + excelFile.getName() + "': Spreadsheet version not supported!");
                throw new IllegalArgumentException("Spreadsheet version not supported!");
            }
        }
        this.excelFile = excelFile;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private void initDefaultStyles() {
        CellStyle cellStyle;
        CellStyle cellStyle2;
        HashMap<String, CellStyle> hashMap = new HashMap<String, CellStyle>(5);
        CellStyle cellStyle3 = this.getCellStyle("XLConnect.Header");
        if (cellStyle3 == null) {
            cellStyle3 = this.createCellStyle("XLConnect.Header");
            cellStyle3.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle3.setFillPattern((short)1);
            cellStyle3.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle3.setWrapText(true);
        }
        if ((cellStyle2 = this.getCellStyle("XLConnect.General")) == null) {
            cellStyle2 = this.createCellStyle("XLConnect.General");
            cellStyle2.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle2.setWrapText(true);
        }
        if ((cellStyle = this.getCellStyle("XLConnect.Date")) == null) {
            cellStyle = this.createCellStyle("XLConnect.Date");
            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
            cellStyle.setWrapText(true);
        }
        hashMap.put("Header", cellStyle3);
        hashMap.put("String", cellStyle2);
        hashMap.put("Numeric", cellStyle2);
        hashMap.put("Boolean", cellStyle2);
        hashMap.put("DateTime", cellStyle);
        this.stylesMap.put("XLCONNECT_STYLE", hashMap);
    }

    private void initDefaultDataFormats() {
        this.dataFormatMap.put(DataType.Boolean, "General");
        this.dataFormatMap.put(DataType.DateTime, "mm/dd/yyyy hh:mm:ss");
        this.dataFormatMap.put(DataType.Numeric, "General");
        this.dataFormatMap.put(DataType.String, "General");
    }

    public final void setDataFormat(DataType dataType, String string) {
        logger.log(Level.INFO, "Setting data format '" + string + "' for type " + dataType.toString());
        this.dataFormatMap.put(dataType, string);
    }

    public final void setStyleAction(StyleAction styleAction) {
        logger.log(Level.INFO, "Setting style action to '" + styleAction.toString() + "'");
        this.styleAction = styleAction;
    }

    public final void setStyleNamePrefix(String styleNamePrefix) {
        logger.log(Level.INFO, "Setting style name prefix to '" + styleNamePrefix + "'");
        this.styleNamePrefix = styleNamePrefix;
    }

    public final String[] getSheets() {
        int count = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[count];
        for (int i = 0; i < count; ++i) {
            logger.log(Level.FINE, "Found worksheet '" + this.workbook.getSheetName(i) + "'");
            sheetNames[i] = this.workbook.getSheetName(i);
        }
        return sheetNames;
    }

    public final int getSheetPos(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    public final void setSheetPos(String sheetName, int pos) {
        logger.log(Level.INFO, "Setting sheet '" + sheetName + "' to position " + pos);
        this.workbook.setSheetOrder(sheetName, pos);
    }

    public final String[] getDefinedNames(boolean bl) {
        int n = this.workbook.getNumberOfNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Name name = this.workbook.getNameAt(i);
            if (bl && !Workbook.isValidReference(name.getRefersToFormula())) continue;
            logger.log(Level.FINE, "Found name '" + name.getNameName() + "'");
            arrayList.add(name.getNameName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final boolean existsSheet(String string) {
        return this.workbook.getSheet(string) != null;
    }

    public final boolean existsName(String string) {
        return this.workbook.getName(string) != null;
    }

    public final void createSheet(String string) {
        if (string.length() > 31) {
            logger.log(Level.SEVERE, "Sheet names are not allowed to contain more than 31 characters!");
            throw new IllegalArgumentException("Sheet names are not allowed to contain more than 31 characters!");
        }
        if (this.workbook.getSheetIndex(string) < 0) {
            logger.log(Level.INFO, "Creating non-existing sheet '" + string + "'");
            this.workbook.createSheet(string);
        }
    }

    public final void removeSheet(int n) {
        if (n >= 0 && n < this.workbook.getNumberOfSheets()) {
            this.setAlternativeActiveSheet(n);
            logger.log(Level.INFO, "Removing sheet " + n);
            this.workbook.removeSheetAt(n);
        }
    }

    public final void removeSheet(String name) {
        logger.log(Level.INFO, "Removing sheet '" + name + "'");
        this.removeSheet(this.workbook.getSheetIndex(name));
    }

    public final void renameSheet(int sheetIndex, String newName) {
        this.renameSheet(this.workbook.getSheetName(sheetIndex), newName);
    }

    public final void renameSheet(String name, String newName) {
        logger.log(Level.INFO, "Renaming sheet '" + name + "' to '" + newName + "'");
        this.workbook.setSheetName(this.workbook.getSheetIndex(name), newName);
    }

    public final void cloneSheet(int index, String newName) {
        this.cloneSheet(this.workbook.getSheetName(index), newName);
    }

    public final void cloneSheet(String name, String newName) {
        logger.log(Level.INFO, "Cloning worksheet '" + name + "' to sheet '" + newName + "'");
        Sheet sheet = this.workbook.cloneSheet(this.workbook.getSheetIndex(name));
        this.workbook.setSheetName(this.workbook.getSheetIndex(sheet), newName);
    }

    public final void createName(String string, String string2, boolean bl) {
        if (this.existsName(string)) {
            logger.log(Level.INFO, "Name already exists");
            if (bl) {
                logger.log(Level.INFO, "Specified to overwrite name if already existing, therefore remove existing name");
                this.removeName(string);
            } else {
                logger.log(Level.SEVERE, "Specified name already exists - specified to not overwrite");
                throw new IllegalArgumentException("Specified name '" + string + "' already exists!");
            }
        }
        Name name = this.workbook.createName();
        try {
            logger.log(Level.INFO, "Creating name '" + string + "' refering to formula '" + string2 + "'");
            name.setNameName(string);
            name.setRefersToFormula(string2);
            return;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Failed creating name '" + string + "'. Cleaning up.");
            string = "XLConnectDummyName";
            name.setNameName(string);
            this.removeName(string);
            throw new IllegalArgumentException(exception);
        }
    }

    public final void removeName(String string) {
        if (this.workbook.getName(string) != null) {
            logger.log(Level.INFO, "Removing name '" + string + "'");
            this.workbook.removeName(string);
        }
    }

    public final String getReferenceFormula(String name) {
        return this.getName(name).getRefersToFormula();
    }

    public final int[] getReferenceCoordinates(String string) {
        string = this.getName(string);
        string = new AreaReference(string.getRefersToFormula());
        CellReference cellReference = string.getFirstCell();
        string = string.getLastCell();
        int n = cellReference.getRow();
        int n2 = string.getRow();
        short s = cellReference.getCol();
        short s2 = string.getCol();
        return new int[]{n, s, n2, s2};
    }

    private void writeData(DataFrame dataFrame, Sheet sheet, int n, int n2, boolean n3) {
        CellStyle cellStyle;
        int n4;
        logger.log(Level.INFO, "Writing data of dimension " + dataFrame.rows() + " rows & " + dataFrame.columns() + " columns" + " to sheet '" + sheet.getSheetName() + "' starting at row " + n + " and column " + n2);
        Map<String, CellStyle> map = this.getStyles(dataFrame, sheet, n, n2);
        int n5 = n;
        int n6 = n2;
        if (n3 != 0 && dataFrame.hasColumnHeader()) {
            for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                logger.log(Level.FINER, "Writing header '" + dataFrame.getColumnName(n3) + "'");
                n4 = n2 + n3;
                cellStyle = Workbook.getCell(sheet, n, n4, true);
                cellStyle.setCellType(1);
                cellStyle.setCellValue(dataFrame.getColumnName(n3));
                this.setCellStyle((Cell)cellStyle, map.get("Header" + n3));
            }
            ++n5;
        }
        for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
            cellStyle = map.get("Column" + n3);
            switch (dataFrame.getColumnType(n3)) {
                case Numeric: {
                    int n7;
                    logger.log(Level.FINE, "Writing numeric column " + n3);
                    Vector vector = dataFrame.getColumn(n3);
                    for (n2 = 0; n2 < dataFrame.rows(); ++n2) {
                        logger.log(Level.FINER, "Writing row " + n2);
                        n4 = n6;
                        n7 = n5 + n2;
                        Cell cell = Workbook.getCell(sheet, n7, n4, true);
                        Double d = (Double)vector.get(n2);
                        if (d == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            this.setMissing(cell);
                            continue;
                        }
                        logger.log(Level.FINEST, "Writing double value '" + d + "'");
                        cell.setCellType(0);
                        cell.setCellValue(d.doubleValue());
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case String: {
                    int n7;
                    logger.log(Level.FINE, "Writing string column " + n3);
                    Vector vector = dataFrame.getColumn(n3);
                    for (int i = 0; i < dataFrame.rows(); ++i) {
                        logger.log(Level.FINER, "Writing row " + i);
                        n4 = n6;
                        n7 = n5 + i;
                        Cell cell = Workbook.getCell(sheet, n7, n4, true);
                        if ((String)vector.get(i) == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            this.setMissing(cell);
                            continue;
                        }
                        logger.log(Level.FINEST, "Writing string value '" + (String)vector.get(i) + "'");
                        cell.setCellType(1);
                        cell.setCellValue((String)vector.get(i));
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case Boolean: {
                    int n7;
                    logger.log(Level.FINE, "Writing boolean column " + n3);
                    Vector vector = dataFrame.getColumn(n3);
                    for (int i = 0; i < dataFrame.rows(); ++i) {
                        logger.log(Level.FINER, "Writing row " + i);
                        n4 = n6;
                        n7 = n5 + i;
                        Cell cell = Workbook.getCell(sheet, n7, n4, true);
                        if ((Boolean)vector.get(i) == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            this.setMissing(cell);
                            continue;
                        }
                        logger.log(Level.FINEST, "Writing boolean value '" + (Boolean)vector.get(i) + "'");
                        cell.setCellType(4);
                        cell.setCellValue(((Boolean)vector.get(i)).booleanValue());
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case DateTime: {
                    int n7;
                    logger.log(Level.FINE, "Writing datetime column " + n3);
                    Vector vector = dataFrame.getColumn(n3);
                    for (n = 0; n < dataFrame.rows(); ++n) {
                        logger.log(Level.FINER, "Writing row " + n);
                        n4 = n6;
                        n7 = n5 + n;
                        Cell cell = Workbook.getCell(sheet, n7, n4, true);
                        Date date = (Date)vector.get(n);
                        if (date == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            this.setMissing(cell);
                            continue;
                        }
                        logger.log(Level.FINEST, "Writing datetime value '" + ((Date)vector.get(n)).toString() + "'");
                        cell.setCellType(0);
                        cell.setCellValue(date);
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "Column " + n3 + ": Unknown column type detected!");
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
            ++n6;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            ((HSSFSheet)sheet).setForceFormulaRecalculation(true);
        }
    }

    private DataFrame readData(Sheet sheet, int n, int n2, int n3, int n4, boolean bl) {
        logger.log(Level.INFO, "Reading data on sheet '" + sheet.getSheetName() + "', start row = " + n + ", start column = " + n2 + ", #rows = " + n3 + ", #columns = " + n4 + ", header = " + bl);
        DataFrame dataFrame = new DataFrame();
        FormulaEvaluator formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.clearAllCachedResultValues();
        block25: for (int i = 0; i < n4; ++i) {
            Object object;
            int n5;
            Object object2;
            Object object3;
            logger.log(Level.FINE, "Reading column " + i);
            int n6 = n2 + i;
            String string = null;
            if (bl && (object3 = Workbook.getCell(sheet, n, n6, false)) != null && (object2 = formulaEvaluator.evaluate((Cell)object3)) != null) {
                string = object2.getStringValue();
                logger.log(Level.FINE, "Found column header '" + string + "'");
            }
            if (string == null) {
                string = "Col" + i;
                logger.log(Level.FINE, "Specified to read column headers but no header found - assuming '" + string + "'");
            }
            object3 = new ColumnBuilder(this, n3);
            int n7 = n5 = bl ? 1 : 0;
            while (n5 < n3) {
                block45: {
                    int n8 = n + n5;
                    logger.log(Level.FINER, "Reading row index " + n8);
                    Cell cell = Workbook.getCell(sheet, n8, n6, false);
                    if (cell == null) {
                        ((ColumnBuilder)object3).addMissing();
                    } else if (cell.getCellType() == 5 || cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 5) {
                        String string2 = "Error detected in cell " + CellUtils.formatAsString(cell) + " - " + CellUtils.getErrorMessage(cell.getErrorCellValue());
                        ColumnBuilder.access$000((ColumnBuilder)object3, string2);
                    } else {
                        try {
                            object = formulaEvaluator.evaluate(cell);
                        }
                        catch (Exception exception) {
                            String string3 = "Error when trying to evaluate cell " + CellUtils.formatAsString(cell) + " - " + exception.getMessage();
                            ColumnBuilder.access$000((ColumnBuilder)object3, string3);
                            break block45;
                        }
                        if (object == null) {
                            ((ColumnBuilder)object3).addMissing();
                        } else {
                            switch (object.getCellType()) {
                                case 3: {
                                    logger.log(Level.FINEST, "Blank cell. Cannot determine data type - assuming 'smallest' data type boolean");
                                    ((ColumnBuilder)object3).addMissing();
                                    break;
                                }
                                case 4: {
                                    logger.log(Level.FINEST, "Found data type boolean");
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.Boolean);
                                    break;
                                }
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        logger.log(Level.FINEST, "Found data type datetime");
                                        ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.DateTime);
                                        break;
                                    }
                                    logger.log(Level.FINEST, "Found data type numeric");
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.Numeric);
                                    break;
                                }
                                case 1: {
                                    logger.log(Level.FINEST, "Found data type string");
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.String);
                                    break;
                                }
                                case 2: {
                                    String string4 = "Formula detected in already evaluated cell " + CellUtils.formatAsString(cell) + "!";
                                    ColumnBuilder.access$000((ColumnBuilder)object3, string4);
                                    break;
                                }
                                case 5: {
                                    String string5 = "Error detected in cell " + CellUtils.formatAsString(cell) + " - " + CellUtils.getErrorMessage(object.getErrorValue());
                                    ColumnBuilder.access$000((ColumnBuilder)object3, string5);
                                    break;
                                }
                                default: {
                                    String string6 = "Unexpected cell type detected for cell " + CellUtils.formatAsString(cell) + "!";
                                    ColumnBuilder.access$000((ColumnBuilder)object3, string6);
                                }
                            }
                        }
                    }
                }
                ++n5;
            }
            logger.log(Level.FINE, "Determining column type based on row types ...");
            object2 = Workbook.determineColumnType(((ColumnBuilder)object3).detectedTypes);
            switch (1.$SwitchMap$com$miraisolutions$xlconnect$data$DataType[((Enum)object2).ordinal()]) {
                case 3: {
                    logger.log(Level.FINER, "Determined column " + i + " to be of data type boolean");
                    Vector<Comparable<Boolean>> vector = new Vector<Comparable<Boolean>>(((ColumnBuilder)object3).values.size());
                    for (CellValue cellValue : ((ColumnBuilder)object3).values) {
                        if (cellValue == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            vector.add(null);
                            continue;
                        }
                        logger.log(Level.FINEST, "Reading boolean value '" + cellValue.getBooleanValue() + "'");
                        vector.add(Boolean.valueOf(cellValue.getBooleanValue()));
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), vector);
                    continue block25;
                }
                case 4: {
                    logger.log(Level.FINER, "Determined column " + i + " to be of data type datetime");
                    Vector<Comparable<Boolean>> vector = new Vector(((ColumnBuilder)object3).values.size());
                    for (CellValue cellValue : ((ColumnBuilder)object3).values) {
                        if (cellValue == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            vector.add(null);
                            continue;
                        }
                        logger.log(Level.FINEST, "Reading datetime value '" + DateUtil.getJavaDate((double)cellValue.getNumberValue()) + "'");
                        vector.add(DateUtil.getJavaDate((double)cellValue.getNumberValue()));
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), vector);
                    continue block25;
                }
                case 1: {
                    logger.log(Level.FINER, "Determined column " + i + " to be of data type numeric");
                    Vector<Comparable<Boolean>> vector = new Vector(((ColumnBuilder)object3).values.size());
                    for (CellValue cellValue : ((ColumnBuilder)object3).values) {
                        if (cellValue == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            vector.add(null);
                            continue;
                        }
                        object = null;
                        switch (cellValue.getCellType()) {
                            case 3: {
                                break;
                            }
                            case 4: {
                                object = cellValue.getBooleanValue() ? 1.0 : 0.0;
                                break;
                            }
                            default: {
                                object = cellValue.getNumberValue();
                            }
                        }
                        logger.log(Level.FINEST, "Reading numeric value '" + object + "'");
                        vector.add((Comparable<Boolean>)object);
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), vector);
                    continue block25;
                }
                case 2: {
                    logger.log(Level.FINER, "Determined column " + i + " to be of data type string");
                    Vector<Comparable<Boolean>> vector = new Vector(((ColumnBuilder)object3).values.size());
                    for (CellValue cellValue : ((ColumnBuilder)object3).values) {
                        if (cellValue == null) {
                            logger.log(Level.FINEST, "Missing value detected");
                            vector.add(null);
                            continue;
                        }
                        object = null;
                        switch (cellValue.getCellType()) {
                            case 3: {
                                break;
                            }
                            case 4: {
                                object = String.valueOf(cellValue.getBooleanValue());
                                break;
                            }
                            case 0: {
                                if (((ColumnBuilder)object3).isDate.contains(cellValue)) {
                                    object = DateUtil.getJavaDate((double)cellValue.getNumberValue()).toString();
                                    break;
                                }
                                object = String.valueOf(cellValue.getNumberValue());
                                break;
                            }
                            default: {
                                object = cellValue.getStringValue();
                            }
                        }
                        logger.log(Level.FINEST, "Reading string value '" + (String)object + "'");
                        vector.add((Comparable<Boolean>)object);
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), vector);
                    continue block25;
                }
                default: {
                    logger.log(Level.SEVERE, "Could not determine column type for column " + i);
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
        }
        return dataFrame;
    }

    public final void onErrorCell(ErrorBehavior errorBehavior) {
        logger.log(Level.INFO, "Setting error cell behavior to " + errorBehavior.toString());
        this.onErrorCell = errorBehavior;
    }

    public final void writeNamedRegion(DataFrame dataFrame, String string, boolean bl) {
        logger.log(Level.INFO, "Writing named region '" + string + "' ...");
        Name name = this.getName(string);
        this.checkName(name);
        Sheet sheet = this.workbook.getSheet(name.getSheetName());
        logger.log(Level.FINE, "Found named region '" + string + "' on sheet '" + sheet.getSheetName() + "'");
        logger.log(Level.FINE, "Named region refers to formula '" + name.getRefersToFormula() + "'");
        CellReference cellReference = new AreaReference(name.getRefersToFormula()).getFirstCell();
        int n = cellReference.getRow() + dataFrame.rows() - 1;
        if (dataFrame.hasColumnHeader()) {
            ++n;
        }
        int n2 = cellReference.getCol() + dataFrame.columns() - 1;
        CellReference cellReference2 = new CellReference(sheet.getSheetName(), n, n2, true, true);
        cellReference2 = new AreaReference(cellReference, cellReference2);
        name.setRefersToFormula(cellReference2.formatAsString());
        this.writeData(dataFrame, sheet, cellReference.getRow(), cellReference.getCol(), bl);
    }

    public final DataFrame readNamedRegion(String string, boolean bl) {
        logger.log(Level.INFO, "Reading named region '" + string + "' ... (header = " + bl + ")");
        Name name = this.getName(string);
        this.checkName(name);
        Sheet sheet = this.workbook.getSheet(name.getSheetName());
        logger.log(Level.FINE, "Found named region '" + string + "' on sheet '" + sheet.getSheetName() + "'");
        logger.log(Level.FINE, "Named region refers to formula '" + name.getRefersToFormula() + "'");
        string = new AreaReference(name.getRefersToFormula());
        name = string.getFirstCell();
        string = string.getLastCell();
        int n = string.getRow() - name.getRow() + 1;
        int n2 = string.getCol() - name.getCol() + 1;
        return this.readData(sheet, name.getRow(), name.getCol(), n, n2, bl);
    }

    public final void writeWorksheet(DataFrame dataFrame, int n, int n2, int n3, boolean bl) {
        logger.log(Level.INFO, "Writing data to worksheet index " + n + ", start row = " + n2 + ", start column = " + n3);
        Sheet sheet = this.workbook.getSheetAt(n);
        this.writeData(dataFrame, sheet, n2, n3, bl);
    }

    public final void writeWorksheet(DataFrame dataFrame, String string, int n, int n2, boolean bl) {
        logger.log(Level.INFO, "Writing data to worksheet '" + string + "'");
        this.writeWorksheet(dataFrame, this.workbook.getSheetIndex(string), n, n2, bl);
    }

    public final void writeWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        this.writeWorksheet(data, worksheetIndex, 0, 0, header);
    }

    public final void writeWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.writeWorksheet(data, worksheetName, 0, 0, header);
    }

    public final DataFrame readWorksheet(int n, int n2, int n3, int n4, int n5, boolean bl) {
        logger.log(Level.INFO, "Reading worksheet " + n + ", start row = " + n2 + ", start column = " + n3 + ", end row = " + n4 + ", end column = " + n5 + ", header = " + bl);
        Sheet sheet = this.workbook.getSheetAt(n);
        if (n2 < 0) {
            n2 = sheet.getFirstRowNum();
        }
        if (n2 < 0) {
            logger.log(Level.SEVERE, "Start row cannot be determined!");
            throw new IllegalArgumentException("Start row cannot be determined!");
        }
        if (sheet.getRow(n2) == null) {
            logger.log(Level.SEVERE, "Specified sheet contains no data!");
            throw new IllegalArgumentException("Specified sheet does not contain any data!");
        }
        if (n4 < 0) {
            n4 = sheet.getLastRowNum();
        }
        if (n4 < 0) {
            logger.log(Level.SEVERE, "End row cannot be determined!");
            throw new IllegalArgumentException("End row cannot be determined!");
        }
        if (n3 < 0) {
            n3 = sheet.getRow(n2).getFirstCellNum();
        }
        if (n3 < 0) {
            logger.log(Level.SEVERE, "Start column cannot be determined!");
            throw new IllegalArgumentException("Start column cannot be determined!");
        }
        if (n5 < 0) {
            n5 = sheet.getRow(n4).getLastCellNum() - 1;
        }
        if (n5 < 0) {
            logger.log(Level.SEVERE, "End column cannot be determined!");
            throw new IllegalArgumentException("End column cannot be determined!");
        }
        return this.readData(sheet, n2, n3, n4 - n2 + 1, n5 - n3 + 1, bl);
    }

    public final DataFrame readWorksheet(int worksheetIndex, boolean header) {
        return this.readWorksheet(worksheetIndex, -1, -1, -1, -1, header);
    }

    public final DataFrame readWorksheet(String string, int n, int n2, int n3, int n4, boolean bl) {
        logger.log(Level.INFO, "Reading worksheet '" + string + "'");
        return this.readWorksheet(this.workbook.getSheetIndex(string), n, n2, n3, n4, bl);
    }

    public final DataFrame readWorksheet(String worksheetName, boolean header) {
        return this.readWorksheet(worksheetName, -1, -1, -1, -1, header);
    }

    /*
     * Unable to fully structure code
     */
    public final void addImage(String var1_1, String var2_2, boolean var3_3) throws FileNotFoundException, IOException {
        block16: {
            block15: {
                var4_5 = var3_3;
                var3_4 = var2_2;
                var2_2 = new File((String)var1_1);
                var1_1 = this;
                Workbook.logger.log(Level.INFO, "Adding image '" + var2_2.getName() + "', original size = " + var4_5);
                var5_6 = super.getName(var3_4);
                var6_7 = var1_1.workbook.getSheet(var5_6.getSheetName());
                Workbook.logger.log(Level.FINE, "Found named region '" + var3_4 + "' on sheet '" + var6_7.getSheetName() + "'");
                Workbook.logger.log(Level.FINE, "Named region refers to formula '" + var5_6.getRefersToFormula() + "'");
                var3_4 = new AreaReference(var5_6.getRefersToFormula());
                var5_6 = var3_4.getFirstCell();
                var3_4 = var3_4.getLastCell();
                var7_8 = var2_2.getName().toLowerCase();
                if (var7_8.endsWith("jpg") || var7_8.endsWith("jpeg")) {
                    var7_9 = 5;
                } else if (var7_8.endsWith("png")) {
                    var7_9 = 6;
                } else if (var7_8.endsWith("wmf")) {
                    var7_9 = 3;
                } else if (var7_8.endsWith("emf")) {
                    var7_9 = 2;
                } else if (var7_8.endsWith("bmp") || var7_8.endsWith("dib")) {
                    var7_9 = 7;
                } else if (var7_8.endsWith("pict") || var7_8.endsWith("pct") || var7_8.endsWith("pic")) {
                    var7_9 = 4;
                } else {
                    Workbook.logger.log(Level.SEVERE, "Image type not supported!");
                    throw new IllegalArgumentException("Image type not supported!");
                }
                var2_2 = new FileInputStream((File)var2_2);
                var8_10 = IOUtils.toByteArray((InputStream)var2_2);
                var7_9 = var1_1.workbook.addPicture(var8_10, var7_9);
                var2_2.close();
                if (!(var1_1.workbook instanceof HSSFWorkbook)) break block15;
                var2_2 = ((HSSFSheet)var6_7).getDrawingPatriarch();
                if (var2_2 != null) break block16;
                ** GOTO lbl-1000
            }
            if (var1_1.workbook instanceof XSSFWorkbook) {
                var2_2 = ((XSSFSheet)var6_7).createDrawingPatriarch();
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = var6_7.createDrawingPatriarch();
            }
        }
        var1_1 = var1_1.workbook.getCreationHelper().createClientAnchor();
        var1_1.setRow1(var5_6.getRow());
        var1_1.setCol1((int)var5_6.getCol());
        var1_1.setRow2(var3_4.getRow() + 1);
        var1_1.setCol2(var3_4.getCol() + 1);
        var1_1.setAnchorType(3);
        var1_1 = var2_2.createPicture((ClientAnchor)var1_1, var7_9);
        if (var4_5) {
            var1_1.resize();
        }
    }

    public final CellStyle createCellStyle(String string) {
        if (this.getCellStyle(string) == null) {
            if (this.workbook instanceof HSSFWorkbook) {
                String string2 = string;
                string = (HSSFWorkbook)this.workbook;
                HSSFCellStyle hSSFCellStyle = string.createCellStyle();
                if (string2 != null) {
                    hSSFCellStyle.setUserStyleName(string2);
                }
                return new HCellStyle((HSSFWorkbook)string, hSSFCellStyle);
            }
            if (this.workbook instanceof XSSFWorkbook) {
                String string3 = string;
                string = (XSSFWorkbook)this.workbook;
                int n = 0;
                CTXf cTXf = CTXf.Factory.newInstance();
                cTXf.setNumFmtId(0L);
                cTXf.setFontId(0L);
                cTXf.setFillId(0L);
                cTXf.setBorderId(0L);
                if (string3 != null) {
                    CTCellStyles cTCellStyles = string.getStylesSource().getCTStylesheet().getCellStyles();
                    if (cTCellStyles == null) {
                        cTCellStyles = string.getStylesSource().getCTStylesheet().addNewCellStyles();
                        cTCellStyles.setCount(0L);
                    }
                    if (cTCellStyles.getCount() == 0L) {
                        CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                        cTCellStyle.setName("Standard");
                        cTCellStyle.setXfId(0L);
                        cTCellStyle.setBuiltinId(0L);
                        cTCellStyles.setCount(1L);
                    }
                    CTXf cTXf2 = CTXf.Factory.newInstance();
                    cTXf2.setNumFmtId(0L);
                    cTXf2.setFontId(0L);
                    cTXf2.setFillId(0L);
                    cTXf2.setBorderId(0L);
                    n = string.getStylesSource().putCellStyleXf(cTXf2);
                    cTXf.setXfId((long)(n - 1));
                    CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                    cTCellStyle.setName(string3);
                    cTCellStyle.setXfId((long)(n - 1));
                    cTCellStyles.setCount(cTCellStyles.getCount() + 1L);
                }
                int n2 = string.getStylesSource().putCellXf(cTXf);
                return new XCellStyle((XSSFWorkbook)string, n2 - 1, n - 1);
            }
            return null;
        }
        logger.log(Level.SEVERE, "Cell style with name '" + string + "' already exists!");
        throw new IllegalArgumentException("Cell style with name '" + string + "' already exists!");
    }

    public final CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public final int getActiveSheetIndex() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return -1;
        }
        return this.workbook.getActiveSheetIndex();
    }

    public final String getActiveSheetName() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return null;
        }
        return this.workbook.getSheetName(this.workbook.getActiveSheetIndex());
    }

    public final void setActiveSheet(int n) {
        logger.log(Level.INFO, "Setting active sheet index: " + n);
        this.workbook.setActiveSheet(n);
    }

    public final void setActiveSheet(String string) {
        logger.log(Level.INFO, "Setting active sheet: " + string);
        int n = this.workbook.getSheetIndex(string);
        this.setActiveSheet(n);
    }

    public final void hideSheet(int n, boolean bl) {
        this.setAlternativeActiveSheet(n);
        logger.log(Level.INFO, (bl ? "Very hiding" : "Hiding") + " sheet with index " + n);
        this.workbook.setSheetHidden(n, bl ? 2 : 1);
    }

    public final void hideSheet(String string, boolean bl) {
        logger.log(Level.INFO, (bl ? "Very hiding" : "Hiding") + " sheet '" + string + "'");
        this.hideSheet(this.workbook.getSheetIndex(string), bl);
    }

    public final void unhideSheet(int n) {
        logger.log(Level.INFO, "Unhiding sheet " + n);
        this.workbook.setSheetHidden(n, 0);
    }

    public final void unhideSheet(String string) {
        logger.log(Level.INFO, "Unhiding sheet '" + string + "'");
        this.unhideSheet(this.workbook.getSheetIndex(string));
    }

    public final boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public final boolean isSheetHidden(String sheetName) {
        return this.isSheetHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public final boolean isSheetVeryHidden(String sheetName) {
        return this.isSheetVeryHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final void setColumnWidth(int n, int n2, int n3) {
        logger.log(Level.INFO, "Setting width of column " + n2 + " on sheet " + n + " to " + n3 + " (in units of 1/256th of a character width)");
        this.getSheet(n).setColumnWidth(n2, n3);
    }

    public final void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.setColumnWidth(this.workbook.getSheetIndex(sheetName), columnIndex, width);
    }

    public final void setRowHeight(int n, int n2, float f) {
        Row row = this.getSheet(n).getRow(n2);
        if (row == null) {
            logger.log(Level.INFO, "Row does not exist - creating it.");
            row = this.getSheet(n).createRow(n2);
        }
        logger.log(Level.INFO, "Setting row " + n2 + " of sheet " + n + " to height " + f + " (in points)");
        row.setHeightInPoints(f);
    }

    public final void setRowHeight(String sheetName, int rowIndex, float height) {
        this.setRowHeight(this.workbook.getSheetIndex(sheetName), rowIndex, height);
    }

    public final void save() throws FileNotFoundException, IOException {
        logger.log(Level.INFO, "Saving workbook to '" + this.excelFile.getCanonicalPath() + "'");
        FileOutputStream fileOutputStream = new FileOutputStream(this.excelFile, false);
        this.workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private Name getName(String string) {
        Name name = this.workbook.getName(string);
        if (name != null) {
            return name;
        }
        logger.log(Level.SEVERE, "Name '" + string + "' does not exist!");
        throw new IllegalArgumentException("Name '" + string + "' does not exist!");
    }

    private static boolean isValidReference(String string) {
        return string != null && !string.startsWith("#REF!") && !string.startsWith("#NULL!");
    }

    private void checkName(Name name) {
        if (!Workbook.isValidReference(name.getRefersToFormula())) {
            logger.log(Level.SEVERE, "Name '" + name.getNameName() + "' has invalid reference!");
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' has invalid reference!");
        }
        if (!this.existsSheet(name.getSheetName())) {
            logger.log(Level.SEVERE, "Name '" + name.getNameName() + "' does not refer to a valid sheet!");
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' does not refer to a valid sheet!");
        }
    }

    private static Cell getCell(Sheet sheet, int n, int n2, boolean bl) {
        Row row = sheet.getRow(n);
        if (row == null) {
            if (bl) {
                row = sheet.createRow(n);
            } else {
                return null;
            }
        }
        if ((sheet = row.getCell(n2)) == null) {
            if (bl) {
                sheet = row.createCell(n2);
            } else {
                return null;
            }
        }
        return sheet;
    }

    private Sheet getSheet(int n) {
        if (n < 0 || n >= this.workbook.getNumberOfSheets()) {
            String string = "Sheet with index " + n + " does not exist!";
            logger.log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        return this.workbook.getSheetAt(n);
    }

    private Sheet getSheet(String string) {
        Sheet sheet = this.workbook.getSheet(string);
        if (sheet == null) {
            string = "Sheet with name '" + string + "' does not exist!";
            logger.log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        return sheet;
    }

    public final void setMissingValue(String value) {
        this.missingValue = value;
    }

    private void setMissing(Cell cell) {
        if (this.missingValue == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellType(1);
        cell.setCellValue(this.missingValue);
        this.setCellStyle(cell, DataFormatOnlyCellStyle.get());
    }

    private static DataType determineColumnType(Vector<DataType> object) {
        DataType dataType = DataType.Boolean;
        object = ((Vector)object).iterator();
        while (object.hasNext() && !dataType.equals((Object)DataType.String)) {
            DataType dataType2 = (DataType)((Object)object.next());
            if (dataType2.ordinal() <= dataType.ordinal()) continue;
            dataType = dataType2;
        }
        return dataType;
    }

    private void setAlternativeActiveSheet(int n) {
        if (n == this.getActiveSheetIndex()) {
            logger.log(Level.INFO, "Sheet to hide or remove is the currently active sheet in the workbook. Relocating active sheet.");
            boolean bl = false;
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                if (i == n || this.workbook.isSheetHidden(i) || this.workbook.isSheetVeryHidden(i)) continue;
                this.setActiveSheet(i);
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Cannot hide or remove sheet as there would be no alternative active sheet left!");
            }
        }
    }

    public final CellStyle getCellStyle(String string) {
        if (this.workbook instanceof HSSFWorkbook) {
            String string2 = string;
            string = (HSSFWorkbook)this.workbook;
            HSSFWorkbook hSSFWorkbook = string;
            for (short s = 0; s < string.getNumCellStyles(); s = (short)(s + 1)) {
                HSSFCellStyle hSSFCellStyle = hSSFWorkbook.getCellStyleAt(s);
                if (hSSFCellStyle.getUserStyleName() == null || !hSSFCellStyle.getUserStyleName().equals(string2)) continue;
                return new HCellStyle((HSSFWorkbook)string, hSSFCellStyle);
            }
            return null;
        }
        if (this.workbook instanceof XSSFWorkbook) {
            String string3 = string;
            string = (XSSFWorkbook)this.workbook;
            CTCellStyles cTCellStyles = string.getStylesSource().getCTStylesheet().getCellStyles();
            if (cTCellStyles != null) {
                int n = 0;
                while ((long)n < cTCellStyles.getCount()) {
                    CTCellStyle cTCellStyle = cTCellStyles.getCellStyleArray(n);
                    if (cTCellStyle.getName().equals(string3)) {
                        int n2 = (int)cTCellStyle.getXfId();
                        return new XCellStyle((XSSFWorkbook)string, -1, n2);
                    }
                    ++n;
                }
            }
            return null;
        }
        return null;
    }

    private CellStyle getCellStyle(Cell cell) {
        return new SSCellStyle(this.workbook, cell.getCellStyle());
    }

    private void setCellStyle(Cell cell, CellStyle cellStyle) {
        if (cellStyle != null) {
            if (cellStyle instanceof HCellStyle) {
                HCellStyle.set((HSSFCell)cell, (HCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof XCellStyle) {
                XCellStyle.set((XSSFCell)cell, (XCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof DataFormatOnlyCellStyle) {
                cellStyle = this.getCellStyle(cell);
                switch (cell.getCellType()) {
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
                            break;
                        }
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Numeric));
                        break;
                    }
                    case 1: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
                        break;
                    }
                    case 4: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Boolean));
                        break;
                    }
                    default: {
                        logger.log(Level.SEVERE, "Unexpected cell type detected!");
                        throw new IllegalArgumentException("Unexpected cell type detected!");
                    }
                }
                SSCellStyle.set(cell, (SSCellStyle)cellStyle);
                return;
            }
            SSCellStyle.set(cell, (SSCellStyle)cellStyle);
        }
    }

    public final void setCellStyle(int n, int n2, int n3, CellStyle cellStyle) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        Cell cell = Workbook.getCell(sheet, n3, n, true);
        this.setCellStyle(cell, cellStyle);
    }

    public final void setCellStyle(String string, int n, int n2, CellStyle cellStyle) {
        int n3 = n2;
        n2 = n;
        Cell cell = Workbook.getCell(this.getSheet(string), n2, n3, true);
        this.setCellStyle(cell, cellStyle);
    }

    private Map<String, CellStyle> getStyles(DataFrame dataFrame, Sheet object, int n, int n2) {
        HashMap<String, CellStyle> hashMap = new HashMap<String, CellStyle>(dataFrame.columns());
        switch (this.styleAction) {
            case XLCONNECT: {
                int n3;
                object = this.stylesMap.get("XLCONNECT_STYLE");
                if (dataFrame.hasColumnHeader()) {
                    for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                        hashMap.put("Header" + n3, (CellStyle)object.get("Header"));
                    }
                }
                block14: for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                    switch (dataFrame.getColumnType(n3)) {
                        case Boolean: {
                            hashMap.put("Column" + n3, (CellStyle)object.get("Boolean"));
                            continue block14;
                        }
                        case DateTime: {
                            hashMap.put("Column" + n3, (CellStyle)object.get("DateTime"));
                            continue block14;
                        }
                        case Numeric: {
                            hashMap.put("Column" + n3, (CellStyle)object.get("Numeric"));
                            continue block14;
                        }
                        case String: {
                            hashMap.put("Column" + n3, (CellStyle)object.get("String"));
                            continue block14;
                        }
                        default: {
                            logger.log(Level.SEVERE, "Unknown column type detected!");
                            throw new IllegalArgumentException("Unknown column type detected!");
                        }
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            case PREDEFINED: {
                int n4;
                int n5;
                if (dataFrame.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame.columns(); ++n5) {
                        n4 = n2 + n5;
                        hashMap.put("Header" + n5, this.getCellStyle(Workbook.getCell((Sheet)object, n, n4, true)));
                    }
                }
                n5 = n + (dataFrame.hasColumnHeader() ? 1 : 0);
                for (n = 0; n < dataFrame.columns(); ++n) {
                    n4 = n2 + n;
                    int n6 = n5;
                    Cell cell = Workbook.getCell((Sheet)object, n6, n4, true);
                    hashMap.put("Column" + n, this.getCellStyle(cell));
                }
                break;
            }
            case STYLE_NAME_PREFIX: {
                String string;
                if (dataFrame.hasColumnHeader()) {
                    for (n = 0; n < dataFrame.columns(); ++n) {
                        string = this.styleNamePrefix + "." + "Header";
                        object = this.getCellStyle(string + "." + dataFrame.getColumnName(n));
                        if (object == null) {
                            logger.log(Level.INFO, "No header style for column '" + dataFrame.getColumnName(n) + "' (specified by column name) found.");
                            object = this.getCellStyle(string + "." + (n + 1));
                        }
                        if (object == null) {
                            logger.log(Level.INFO, "No header style for column '" + dataFrame.getColumnName(n) + "' (specified by index) found.");
                            object = this.getCellStyle(string);
                        }
                        if (object == null) {
                            logger.log(Level.WARNING, "No header style found for header '" + dataFrame.getColumnName(n) + "' - taking default");
                            object = new SSCellStyle(this.workbook, this.workbook.getCellStyleAt((short)0));
                        }
                        hashMap.put("Header" + n, (CellStyle)object);
                    }
                }
                for (n = 0; n < dataFrame.columns(); ++n) {
                    string = this.styleNamePrefix + "." + "Column";
                    object = this.getCellStyle(string + "." + dataFrame.getColumnName(n));
                    if (object == null) {
                        logger.log(Level.INFO, "No column style for column '" + dataFrame.getColumnName(n) + "' (specified by column name) found.");
                        object = this.getCellStyle(string + "." + (n + 1));
                    }
                    if (object == null) {
                        logger.log(Level.INFO, "No column style for column '" + dataFrame.getColumnName(n) + "' (specified by index) found.");
                        object = this.getCellStyle(string + "." + dataFrame.getColumnType(n).toString());
                    }
                    if (object == null) {
                        logger.log(Level.WARNING, "No column style found for column '" + dataFrame.getColumnName(n) + "' - taking default");
                        object = new SSCellStyle(this.workbook, this.workbook.getCellStyleAt((short)0));
                    }
                    hashMap.put("Column" + n, (CellStyle)object);
                }
                break;
            }
            case DATA_FORMAT_ONLY: {
                int n7;
                DataFormatOnlyCellStyle dataFormatOnlyCellStyle = DataFormatOnlyCellStyle.get();
                if (dataFrame.hasColumnHeader()) {
                    for (n7 = 0; n7 < dataFrame.columns(); ++n7) {
                        hashMap.put("Header" + n7, dataFormatOnlyCellStyle);
                    }
                }
                for (n7 = 0; n7 < dataFrame.columns(); ++n7) {
                    hashMap.put("Column" + n7, dataFormatOnlyCellStyle);
                }
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Style action not supported!");
                throw new IllegalArgumentException("Style action not supported!");
            }
        }
        return hashMap;
    }

    public final void mergeCells(int n, String string) {
        this.getSheet(n).addMergedRegion(CellRangeAddress.valueOf((String)string));
    }

    public final void mergeCells(String string, String string2) {
        this.getSheet(string).addMergedRegion(CellRangeAddress.valueOf((String)string2));
    }

    public final void unmergeCells(int n, String string) {
        Sheet sheet = this.getSheet(n);
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            if (!sheet.getMergedRegion(i).formatAsString().equals(string)) continue;
            sheet.removeMergedRegion(i);
            return;
        }
    }

    public final void unmergeCells(String sheetName, String reference) {
        this.unmergeCells(this.workbook.getSheetIndex(sheetName), reference);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Workbook getWorkbook(String object, boolean bl) throws FileNotFoundException, IOException, InvalidFormatException {
        if (((File)(object = new File((String)object))).exists()) {
            logger.log(Level.INFO, "Creating XLConnect workbook instance for existing file '" + ((File)object).getCanonicalPath() + "'");
            object = new Workbook((File)object);
        } else {
            if (!bl) {
                logger.log(Level.SEVERE, "File '" + ((File)object).getName() + "' could not be found - " + "you may specify to automatically create the file if not existing.");
                throw new FileNotFoundException("File '" + ((File)object).getName() + "' could not be found - " + "you may specify to automatically create the file if not existing.");
            }
            logger.log(Level.INFO, "Creating XLConnect workbook instance for new file '" + ((File)object).getCanonicalPath() + "'");
            String string = ((File)object).getName().toLowerCase();
            if (string.endsWith(".xls")) {
                object = new Workbook((File)object, SpreadsheetVersion.EXCEL97);
            } else {
                if (!string.endsWith(".xlsx")) {
                    logger.log(Level.SEVERE, "File extension not supported! Only *.xls and *.xlsx are allowed!");
                    throw new IllegalArgumentException("File extension not supported! Only *.xls and *.xlsx are allowed!");
                }
                object = new Workbook((File)object, SpreadsheetVersion.EXCEL2007);
            }
        }
        logger.log(Level.INFO, "Excel version: " + (((Workbook)object).workbook instanceof HSSFWorkbook ? SpreadsheetVersion.EXCEL97.toString() : SpreadsheetVersion.EXCEL2007.toString()));
        return object;
    }

    public final void setCellFormula(int n, int n2, int n3, String string) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        Workbook.getCell(sheet, n3, n, true).setCellFormula(string);
    }

    public final void setCellFormula(String string, int n, int n2, String string2) {
        int n3 = n2;
        n2 = n;
        Workbook.getCell(this.getSheet(string), n2, n3, true).setCellFormula(string2);
    }

    public final String getCellFormula(int n, int n2, int n3) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        return Workbook.getCell(sheet, n3, n, true).getCellFormula();
    }

    public final String getCellFormula(String string, int n, int n2) {
        int n3 = n2;
        n2 = n;
        return Workbook.getCell(this.getSheet(string), n2, n3, true).getCellFormula();
    }

    public final boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.getSheet(sheetIndex).getForceFormulaRecalculation();
    }

    public final boolean getForceFormulaRecalculation(String sheetName) {
        return this.getSheet(sheetName).getForceFormulaRecalculation();
    }

    public final void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.getSheet(sheetIndex).setForceFormulaRecalculation(value);
    }

    public final void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.getSheet(sheetName).setForceFormulaRecalculation(value);
    }

    public final void setAutoFilter(int n, String string) {
        this.getSheet(n).setAutoFilter(CellRangeAddress.valueOf((String)string));
    }

    public final void setAutoFilter(String string, String string2) {
        this.getSheet(string).setAutoFilter(CellRangeAddress.valueOf((String)string2));
    }

    public final class ColumnBuilder {
        Vector<DataType> detectedTypes;
        Vector<CellValue> values;
        Vector<CellValue> isDate = new Vector();
        private /* synthetic */ Workbook this$0;

        public ColumnBuilder(Workbook workbook, int n) {
            this.this$0 = workbook;
            this.detectedTypes = new Vector(n);
            this.values = new Vector(n);
        }

        public final void addMissing() {
            logger.log(Level.FINEST, "Cannot determine data type - assuming 'smallest' data type boolean");
            this.values.add(null);
            this.detectedTypes.add(DataType.Boolean);
        }

        static /* synthetic */ void access$000(ColumnBuilder columnBuilder, String string) {
            if (columnBuilder.this$0.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
                logger.log(Level.WARNING, string);
                columnBuilder.values.add(null);
                columnBuilder.detectedTypes.add(DataType.Boolean);
                columnBuilder.this$0.addWarning(string);
                return;
            }
            logger.log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }

        static /* synthetic */ void access$100(ColumnBuilder columnBuilder, CellValue cellValue, DataType dataType) {
            if (DataType.DateTime.equals((Object)dataType)) {
                columnBuilder.isDate.add(cellValue);
            }
            columnBuilder.values.add(cellValue);
            columnBuilder.detectedTypes.add(dataType);
        }
    }
}

