/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal.marshallers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import org.apache.poi.openxml4j.opc.internal.marshallers.ZipPackagePropertiesMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class TestZipPackagePropertiesMarshaller {
    private PartMarshaller marshaller = new ZipPackagePropertiesMarshaller();

    @Test(expected=IllegalArgumentException.class)
    public void nonZipOutputStream() throws OpenXML4JException {
        ByteArrayOutputStream notAZipOutputStream = new ByteArrayOutputStream(0);
        this.marshaller.marshall(null, notAZipOutputStream);
    }

    @Test
    public void withZipOutputStream() throws Exception {
        Assert.assertTrue((boolean)this.marshaller.marshall(new PackagePropertiesPart(null, PackagingURIHelper.createPartName(PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_URI)), new ZipOutputStream(new ByteArrayOutputStream())));
    }

    @Test
    public void writingFails() throws Exception {
        Assert.assertTrue((boolean)this.marshaller.marshall(new PackagePropertiesPart(null, PackagingURIHelper.createPartName(PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_URI)), new ZipOutputStream(new ByteArrayOutputStream())));
    }

    @Test(expected=OpenXML4JException.class)
    public void ioException() throws Exception {
        this.marshaller.marshall(new PackagePropertiesPart(null, PackagingURIHelper.createPartName(PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_URI)), new ZipOutputStream(new ByteArrayOutputStream()){

            @Override
            public void putNextEntry(ZipEntry e) throws IOException {
                throw new IOException("TestException");
            }
        });
    }
}

