/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.poi.util.Internal;
import org.apache.poi.util.SuppressForbidden;

@Internal
public class Util {
    public static final long EPOCH_DIFF = 11644473600000L;

    public static Date filetimeToDate(int high, int low) {
        long filetime = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        return Util.filetimeToDate(filetime);
    }

    public static Date filetimeToDate(long filetime) {
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        return new Date(ms_since_19700101);
    }

    public static long dateToFileTime(Date date) {
        long ms_since_19700101 = date.getTime();
        long ms_since_16010101 = ms_since_19700101 + 11644473600000L;
        return ms_since_16010101 * 10000L;
    }

    public static boolean equals(Object[] c1, Object[] c2) {
        for (int i1 = 0; i1 < c1.length; ++i1) {
            Object obj1 = c1[i1];
            boolean matchFound = false;
            for (int i2 = 0; !matchFound && i2 < c1.length; ++i2) {
                Object obj2 = c2[i2];
                if (!obj1.equals(obj2)) continue;
                matchFound = true;
                c2[i2] = null;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static byte[] pad4(byte[] ba) {
        byte[] result;
        int PAD = 4;
        int l = ba.length % 4;
        if (l == 0) {
            result = ba;
        } else {
            l = 4 - l;
            result = new byte[ba.length + l];
            System.arraycopy(ba, 0, result, 0, ba.length);
        }
        return result;
    }

    @SuppressForbidden(value="uses printStackTrace")
    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        try {
            sw.close();
            return sw.toString();
        }
        catch (IOException e) {
            StringBuffer b = new StringBuffer(t.getMessage());
            b.append("\n");
            b.append("Could not create a stacktrace. Reason: ");
            b.append(e.getMessage());
            return b.toString();
        }
    }
}

