/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public final class XCellStyle
extends Common
implements CellStyle {
    private final XSSFWorkbook workbook;
    private final int xfId;
    private final int styleXfId;
    private XSSFCellAlignment cellAlignment;

    public XCellStyle(XSSFWorkbook workbook, int xfId, int styleXfId) {
        this.workbook = workbook;
        this.xfId = xfId;
        this.styleXfId = styleXfId;
    }

    private CTXf getCoreXf() {
        if (this.xfId < 0) {
            return this.workbook.getStylesSource().getCellXfAt(0);
        }
        return this.workbook.getStylesSource().getCellXfAt(this.xfId);
    }

    private CTXf getXf() {
        if (this.styleXfId > -1) {
            return this.workbook.getStylesSource().getCellStyleXfAt(this.styleXfId);
        }
        return this.getCoreXf();
    }

    private CTBorder getCTBorder() {
        XCellStyle xCellStyle;
        CTXf cTXf = xCellStyle.getXf();
        if (cTXf.getApplyBorder()) {
            int n = (int)cTXf.getBorderId();
            xCellStyle = (CTBorder)xCellStyle.workbook.getStylesSource().getBorderAt(n).getCTBorder().copy();
        } else {
            xCellStyle = CTBorder.Factory.newInstance();
        }
        return xCellStyle;
    }

    private CTFill getCTFill() {
        XCellStyle xCellStyle;
        CTXf cTXf = xCellStyle.getXf();
        if (cTXf.getApplyFill()) {
            int n = (int)cTXf.getFillId();
            xCellStyle = (CTFill)xCellStyle.workbook.getStylesSource().getFillAt(n).getCTFill().copy();
        } else {
            xCellStyle = CTFill.Factory.newInstance();
        }
        return xCellStyle;
    }

    public final void setBorderBottom(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom();
        if (s == 0) {
            cTBorder.unsetBottom();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderLeft(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft();
        if (s == 0) {
            cTBorder.unsetLeft();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderRight(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight();
        if (s == 0) {
            cTBorder.unsetRight();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderTop(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop();
        if (s == 0) {
            cTBorder.unsetTop();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBottomBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTBorder();
        (xSSFColor.isSetBottom() ? xSSFColor.getBottom() : xSSFColor.addNewBottom()).setColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putBorder(new XSSFCellBorder((CTBorder)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setBorderId((long)n);
        xSSFColor.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)n);
    }

    public final void setLeftBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTBorder();
        (xSSFColor.isSetLeft() ? xSSFColor.getLeft() : xSSFColor.addNewLeft()).setColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putBorder(new XSSFCellBorder((CTBorder)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setBorderId((long)n);
        xSSFColor.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)n);
    }

    public final void setRightBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTBorder();
        (xSSFColor.isSetRight() ? xSSFColor.getRight() : xSSFColor.addNewRight()).setColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putBorder(new XSSFCellBorder((CTBorder)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setBorderId((long)n);
        xSSFColor.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)n);
    }

    public final void setTopBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTBorder();
        (xSSFColor.isSetTop() ? xSSFColor.getTop() : xSSFColor.addNewTop()).setColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putBorder(new XSSFCellBorder((CTBorder)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setBorderId((long)n);
        xSSFColor.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)n);
    }

    public final void setDataFormat(String string) {
        short s = this.workbook.createDataFormat().getFormat(string);
        CTXf cTXf = this.getXf();
        cTXf.setApplyNumberFormat(true);
        cTXf.setNumFmtId((long)s);
        this.getCoreXf().setNumFmtId((long)s);
    }

    public final void setFillBackgroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTFill();
        CTPatternFill cTPatternFill = xSSFColor.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = xSSFColor.addNewPatternFill();
        }
        cTPatternFill.setBgColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putFill(new XSSFCellFill((CTFill)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setFillId((long)n);
        xSSFColor.setApplyFill(true);
        this.getCoreXf().setFillId((long)n);
    }

    public final void setFillForegroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XSSFColor xSSFColor2 = xSSFColor;
        xSSFColor = this.getCTFill();
        CTPatternFill cTPatternFill = xSSFColor.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = xSSFColor.addNewPatternFill();
        }
        cTPatternFill.setFgColor(xSSFColor2.getCTColor());
        int n = this.workbook.getStylesSource().putFill(new XSSFCellFill((CTFill)xSSFColor));
        xSSFColor = this.getXf();
        xSSFColor.setFillId((long)n);
        xSSFColor.setApplyFill(true);
        this.getCoreXf().setFillId((long)n);
    }

    public final void setFillPattern(short s) {
        CTPatternFill cTPatternFill;
        CTFill cTFill = this.getCTFill();
        CTPatternFill cTPatternFill2 = cTPatternFill = cTFill.isSetPatternFill() ? cTFill.getPatternFill() : cTFill.addNewPatternFill();
        if (s == 0 && cTPatternFill.isSetPatternType()) {
            cTPatternFill.unsetPatternType();
        } else {
            cTPatternFill.setPatternType(STPatternType.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = this.getXf();
        cTFill.setFillId((long)s);
        cTFill.setApplyFill(true);
        this.getCoreXf().setFillId((long)s);
    }

    public final void setWrapText(boolean bl) {
        if (this.cellAlignment == null) {
            CTXf cTXf = this.getXf();
            if (cTXf.getAlignment() == null) {
                cTXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            this.cellAlignment = new XSSFCellAlignment(cTXf.getAlignment());
        }
        this.cellAlignment.setWrapText(bl);
    }

    public static void set(XSSFCell xSSFCell, XCellStyle xCellStyle) {
        if (xCellStyle.xfId < 0) {
            XCellStyle xCellStyle2 = xCellStyle;
            xCellStyle2 = xCellStyle2.workbook.getStylesSource().getCellStyleXfAt(xCellStyle2.styleXfId);
            CTXf cTXf = CTXf.Factory.newInstance();
            cTXf.setNumFmtId(xCellStyle2.getNumFmtId());
            cTXf.setFontId(xCellStyle2.getFontId());
            cTXf.setFillId(xCellStyle2.getFillId());
            cTXf.setBorderId(xCellStyle2.getBorderId());
            cTXf.setAlignment(xCellStyle2.getAlignment());
            cTXf.setXfId((long)xCellStyle.styleXfId);
            int n = xCellStyle.workbook.getStylesSource().putCellXf(cTXf);
            xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(n - 1, xCellStyle.styleXfId, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
            return;
        }
        if (xCellStyle.styleXfId < 0) {
            int n = 0;
            int n2 = (int)xCellStyle.workbook.getStylesSource().getCellXfAt(xCellStyle.xfId).getXfId();
            if (n2 > 0) {
                n = n2;
            }
            xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xCellStyle.xfId, n, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
            return;
        }
        xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xCellStyle.xfId, xCellStyle.styleXfId, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
    }
}

