/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public final class ColumnBuilder
extends Common {
    private ArrayList<DataType> detectedTypes;
    private ArrayList<Cell> cells;
    private ArrayList<CellValue> values;
    private String dateTimeFormat;
    private boolean forceConversion;
    private boolean takeCached = false;
    private FormulaEvaluator evaluator = null;
    private ErrorBehavior onErrorCell;
    private String[] missingValueStrings;
    private double[] missingValueNumbers;

    public ColumnBuilder(int n, boolean bl, FormulaEvaluator formulaEvaluator, ErrorBehavior errorBehavior, Object[] objectArray) {
        int n2;
        this.detectedTypes = new ArrayList(n);
        this.cells = new ArrayList(n);
        this.values = new ArrayList(n);
        this.forceConversion = bl;
        this.evaluator = formulaEvaluator;
        this.takeCached = formulaEvaluator == null;
        this.onErrorCell = errorBehavior;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] instanceof String) {
                arrayList2.add((String)objectArray[n2]);
                continue;
            }
            if (!(objectArray[n2] instanceof Double)) continue;
            arrayList.add((Double)objectArray[n2]);
        }
        this.missingValueStrings = arrayList2.toArray(new String[arrayList2.size()]);
        this.missingValueNumbers = new double[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this.missingValueNumbers[n2] = (Double)arrayList.get(n2);
        }
    }

    private void addMissing() {
        this.values.add(null);
        this.cells.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    private void cellError(String string) {
        if (this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            this.addMissing();
            this.addWarning(string);
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public final void addCell(Cell object) {
        Object object2;
        if (object == null) {
            this.addMissing();
            return;
        }
        if (object.getCellType() == 5 || object.getCellType() == 2 && object.getCachedFormulaResultType() == 5) {
            object = "Error detected in cell " + CellUtils.formatAsString(object) + " - " + CellUtils.getErrorMessage(object.getErrorCellValue());
            this.cellError((String)object);
            return;
        }
        try {
            CellValue cellValue;
            block27: {
                Cell cell;
                block26: {
                    cell = object;
                    object2 = this;
                    if (!((ColumnBuilder)object2).takeCached) break block26;
                    object2 = cell;
                    int n = object2.getCellType();
                    if (n == 2) {
                        n = object2.getCachedFormulaResultType();
                    }
                    switch (n) {
                        case 3: {
                            cellValue = null;
                            break block27;
                        }
                        case 4: {
                            cellValue = object2.getBooleanCellValue() ? CellValue.TRUE : CellValue.FALSE;
                            break block27;
                        }
                        case 0: {
                            cellValue = new CellValue(object2.getNumericCellValue());
                            break block27;
                        }
                        case 1: {
                            cellValue = new CellValue(object2.getStringCellValue());
                            break block27;
                        }
                        case 5: {
                            cellValue = CellValue.getError((int)object2.getErrorCellValue());
                            break block27;
                        }
                        default: {
                            object2 = String.format("Could not extract value from cell with cached value type %d", n);
                            throw new RuntimeException((String)object2);
                        }
                    }
                }
                cellValue = ((ColumnBuilder)object2).evaluator.evaluate(cell);
            }
            object2 = cellValue;
        }
        catch (Exception exception) {
            object = "Error when trying to evaluate cell " + CellUtils.formatAsString(object) + " - " + exception.getMessage();
            this.cellError((String)object);
            return;
        }
        if (object2 == null) {
            this.addMissing();
            return;
        }
        switch (object2.getCellType()) {
            case 3: {
                this.addMissing();
                return;
            }
            case 4: {
                this.addValue((Cell)object, (CellValue)object2, DataType.Boolean);
                return;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)object)) {
                    this.addValue((Cell)object, (CellValue)object2, DataType.DateTime);
                    return;
                }
                boolean bl = false;
                for (int i = 0; i < this.missingValueNumbers.length; ++i) {
                    if (object2.getNumberValue() != this.missingValueNumbers[i]) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.addMissing();
                    return;
                }
                this.addValue((Cell)object, (CellValue)object2, DataType.Numeric);
                return;
            }
            case 1: {
                boolean bl = false;
                for (int i = 0; i < this.missingValueStrings.length; ++i) {
                    if (object2.getStringValue() != null && !object2.getStringValue().equals(this.missingValueStrings[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.addMissing();
                    return;
                }
                this.addValue((Cell)object, (CellValue)object2, DataType.String);
                return;
            }
            case 2: {
                object = "Formula detected in already evaluated cell " + CellUtils.formatAsString(object) + "!";
                this.cellError((String)object);
                return;
            }
            case 5: {
                object = "Error detected in cell " + CellUtils.formatAsString(object) + " - " + CellUtils.getErrorMessage(object2.getErrorValue());
                this.cellError((String)object);
                return;
            }
        }
        object = "Unexpected cell type detected for cell " + CellUtils.formatAsString(object) + "!";
        this.cellError((String)object);
    }

    private void addValue(Cell cell, CellValue cellValue, DataType dataType) {
        this.cells.add(cell);
        this.values.add(cellValue);
        this.detectedTypes.add(dataType);
    }

    public final DataType determineColumnType() {
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = ((ColumnBuilder)((Object)this)).detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            DataType dt = (DataType)((Object)it.next());
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = dt;
        }
        return columnType;
    }

    public final ArrayList build(DataType dataType) {
        dataType = dataType == null ? this.determineColumnType() : dataType;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.values.size());
        Iterator<CellValue> iterator = this.values.iterator();
        Iterator<Cell> iterator2 = this.cells.iterator();
        DataFormatter dataFormatter = new DataFormatter();
        int n = 0;
        while (iterator.hasNext()) {
            CellValue cellValue = iterator.next();
            Cell cell = iterator2.next();
            if (cellValue == null) {
                arrayList.add(null);
            } else {
                block2 : switch (dataType) {
                    case Boolean: {
                        switch (this.detectedTypes.get(n)) {
                            case Boolean: {
                                arrayList.add(cellValue.getBooleanValue());
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    arrayList.add(cellValue.getNumberValue() > 0.0);
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    arrayList.add(Boolean.valueOf(cellValue.getStringValue().toLowerCase()));
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                            case DateTime: {
                                arrayList.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(n)) + " cannot be converted from DateTime to Boolean - returning NA");
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case DateTime: {
                        switch (this.detectedTypes.get(n)) {
                            case Boolean: {
                                arrayList.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(n)) + " cannot be converted from Boolean to DateTime - returning NA");
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    if (DateUtil.isValidExcelDate((double)cellValue.getNumberValue())) {
                                        arrayList.add(DateUtil.getJavaDate((double)cellValue.getNumberValue()));
                                        break block2;
                                    }
                                    arrayList.add(null);
                                    this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(n)) + " cannot be converted from Numeric to DateTime - returning NA");
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        arrayList.add(Workbook.dateTimeFormatter.parse(cellValue.getStringValue(), this.dateTimeFormat));
                                    }
                                    catch (Exception exception) {
                                        arrayList.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(n)) + " cannot be converted from String to DateTime - returning NA");
                                    }
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                            case DateTime: {
                                arrayList.add(DateUtil.getJavaDate((double)cellValue.getNumberValue()));
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case Numeric: {
                        switch (this.detectedTypes.get(n)) {
                            case Boolean: {
                                arrayList.add(cellValue.getBooleanValue() ? 1.0 : 0.0);
                                break block2;
                            }
                            case Numeric: {
                                arrayList.add(cellValue.getNumberValue());
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        arrayList.add(Double.parseDouble(cellValue.getStringValue()));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        arrayList.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(n)) + " cannot be converted from String to Numeric - returning NA");
                                    }
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                            case DateTime: {
                                if (this.forceConversion) {
                                    arrayList.add(cellValue.getNumberValue());
                                    break block2;
                                }
                                arrayList.add(null);
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case String: {
                        switch (this.detectedTypes.get(n)) {
                            case Boolean: 
                            case Numeric: {
                                arrayList.add(dataFormatter.formatCellValue(cell, this.evaluator));
                                break block2;
                            }
                            case DateTime: {
                                arrayList.add(Workbook.dateTimeFormatter.format(DateUtil.getJavaDate((double)cellValue.getNumberValue()), this.dateTimeFormat));
                                break block2;
                            }
                            case String: {
                                arrayList.add(cellValue.getStringValue());
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type detected!");
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    public final void setDateTimeFormat(String format) {
        this.dateTimeFormat = format;
    }
}

