/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public final class XCellStyle
extends Common
implements CellStyle {
    private final XSSFWorkbook workbook;
    private final int xfId;
    private final int styleXfId;
    private XSSFCellAlignment cellAlignment;

    /*
     * WARNING - void declaration
     */
    public XCellStyle(XSSFWorkbook workbook, int xfId, int styleXfId) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.workbook = var1_1;
        this.xfId = var2_2;
        this.styleXfId = var3_3;
    }

    private CTXf getCoreXf() {
        if (this.xfId < 0) {
            return this.workbook.getStylesSource().getCellXfAt(0);
        }
        return this.workbook.getStylesSource().getCellXfAt(this.xfId);
    }

    private CTXf getXf() {
        if (this.styleXfId >= 0) {
            return this.workbook.getStylesSource().getCellStyleXfAt(this.styleXfId);
        }
        return this.getCoreXf();
    }

    /*
     * WARNING - void declaration
     */
    private CTBorder getCTBorder() {
        void var1_1;
        CTBorder ct;
        CTXf xf = this.getXf();
        if (xf.getApplyBorder()) {
            int idx = (int)xf.getBorderId();
            ct = (CTBorder)this.workbook.getStylesSource().getBorderAt(idx).getCTBorder().copy();
        } else {
            ct = CTBorder.Factory.newInstance();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private CTFill getCTFill() {
        void var1_1;
        CTFill ct;
        CTXf xf = this.getXf();
        if (xf.getApplyFill()) {
            int fillIndex = (int)xf.getFillId();
            ct = (CTFill)this.workbook.getStylesSource().getFillAt(fillIndex).getCTFill().copy();
        } else {
            ct = CTFill.Factory.newInstance();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBorderBottom(short border) {
        void var1_1;
        void var2_2;
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (border == 0) {
            ct.unsetBottom();
        } else {
            void var3_3;
            var3_3.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        var2_2.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBorderLeft(short border) {
        void var1_1;
        void var2_2;
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (border == 0) {
            ct.unsetLeft();
        } else {
            void var3_3;
            var3_3.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        var2_2.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBorderRight(short border) {
        void var1_1;
        void var2_2;
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (border == 0) {
            ct.unsetRight();
        } else {
            void var3_3;
            var3_3.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        var2_2.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBorderTop(short border) {
        void var1_1;
        void var2_2;
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (border == 0) {
            ct.unsetTop();
        } else {
            void var3_3;
            var3_3.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this.workbook.getStylesSource().putBorder(new XSSFCellBorder(ct));
        CTXf xf = this.getXf();
        xf.setBorderId((long)idx);
        var2_2.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBottomBorderColor(short color) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom()).setColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setLeftBorderColor(short color) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft()).setColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRightBorderColor(short color) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight()).setColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTopBorderColor(short color) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop()).setColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataFormat(String format) {
        void var1_2;
        void var2_3;
        short fmtId = this.workbook.createDataFormat().getFormat(format);
        CTXf xf = this.getXf();
        xf.setApplyNumberFormat(true);
        var2_3.setNumFmtId((long)fmtId);
        this.getCoreXf().setNumFmtId((long)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setFillBackgroundColor(short bg) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTFill cTFill = xCellStyle.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = cTFill.addNewPatternFill();
        }
        cTPatternFill.setBgColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = xCellStyle.getXf();
        cTFill.setFillId((long)n);
        cTFill.setApplyFill(true);
        xCellStyle.getCoreXf().setFillId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setFillForegroundColor(short fg) {
        void var2_3;
        void var1_1;
        XSSFColor clr = new XSSFColor();
        clr.setIndexed((int)var1_1);
        XCellStyle xCellStyle = this;
        CTFill cTFill = xCellStyle.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = cTFill.addNewPatternFill();
        }
        cTPatternFill.setFgColor(var2_3.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = xCellStyle.getXf();
        cTFill.setFillId((long)n);
        cTFill.setApplyFill(true);
        xCellStyle.getCoreXf().setFillId((long)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setFillPattern(short fp) {
        void var1_1;
        void var2_2;
        CTPatternFill ptrn;
        CTFill ct = this.getCTFill();
        CTPatternFill cTPatternFill = ptrn = ct.isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == 0 && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            void var3_3;
            var3_3.setPatternType(STPatternType.Enum.forInt((int)(fp + 1)));
        }
        int idx = this.workbook.getStylesSource().putFill(new XSSFCellFill(ct));
        CTXf xf = this.getXf();
        xf.setFillId((long)idx);
        var2_2.setApplyFill(true);
        this.getCoreXf().setFillId((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setWrapText(boolean wrap) {
        void var1_1;
        XCellStyle xCellStyle = this;
        if (xCellStyle.cellAlignment == null) {
            CTXf cTXf = xCellStyle.getXf();
            if (cTXf.getAlignment() == null) {
                cTXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            xCellStyle.cellAlignment = new XSSFCellAlignment(cTXf.getAlignment());
        }
        xCellStyle.cellAlignment.setWrapText((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void set(XSSFCell c, XCellStyle cs) {
        void var1_1;
        XSSFCell xSSFCell;
        if (cs.xfId < 0) {
            XCellStyle xCellStyle = cs;
            CTXf styleXf = xCellStyle.workbook.getStylesSource().getCellStyleXfAt(xCellStyle.styleXfId);
            CTXf xf = CTXf.Factory.newInstance();
            xf.setNumFmtId(styleXf.getNumFmtId());
            xf.setFontId(styleXf.getFontId());
            xf.setFillId(styleXf.getFillId());
            xf.setBorderId(styleXf.getBorderId());
            xf.setAlignment(styleXf.getAlignment());
            xf.setXfId((long)cs.styleXfId);
            int xfSize = cs.workbook.getStylesSource().putCellXf(xf);
            c.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xfSize - 1, cs.styleXfId, cs.workbook.getStylesSource(), cs.workbook.getTheme()));
            return;
        }
        if (cs.styleXfId < 0) {
            void var2_4;
            boolean styleXfId = false;
            int id = (int)cs.workbook.getStylesSource().getCellXfAt(cs.xfId).getXfId();
            if (id > 0) {
                void var3_6;
                styleXfId = var3_6;
            }
            c.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(cs.xfId, (int)var2_4, cs.workbook.getStylesSource(), cs.workbook.getTheme()));
            return;
        }
        xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(cs.xfId, cs.styleXfId, cs.workbook.getStylesSource(), var1_1.workbook.getTheme()));
    }
}

