% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provide_file.R
\name{provide_file}
\alias{provide_file}
\title{Manage static files in project directory}
\usage{
provide_file(rel, to, from, overwrite = TRUE, mode = "0777", quiet = FALSE)
}
\arguments{
\item{rel}{Relative path of file as to be used in HTML.}

\item{to}{Full path to the project directory where files should be copied to.}

\item{from}{Full path to the directory where the file can be found under its \code{rel_path}.}

\item{overwrite}{Logical, whether existing files should be re-written or kept in place.}

\item{mode}{Permissions for newly created directories below \code{to}.}

\item{quiet}{Logical,
      whether you would like to see a message when files are copied or already exist.}
}
\value{
When called, the file is copied from the \code{from} to the \code{to} directory,
   including the relative path given by \code{rel}. Missing target directories below \code{to}
   are created on-the-fly. If successful,
      the function finally returns an invisible character
   string identical to \code{rel}.
}
\description{
Copies or overwrites files from a source directory to your project directory. Can be used
to make sure that files you are referencing in your generated XML code are present and up to date.
}
\details{
The function returns the relative path that was given as its first argument,
      e.g. it can be used
inside \code{XMLNode} to add relative paths to arguments while also copying the referenced file
to the given output directory, keeping the relative path.

It can be useful to write a simple wrapper around this function to set the relevant \code{from}
and \code{to} paths for a project (see examples).
}
\examples{
\dontrun{
# a direct call that would copy the file ~/webpage/v1/static/css/bootstrap.min.css
# to the project directory as /tmp/static/css/bootstrap.min.css
# and include "static/css/bootstrap.min.css" in the <link> tag
my_HTML <- XMLNode(
  "link",
  rel="stylesheet",
  type="text/css",
  href=provide_file(
    rel="static/css/bootstrap.min.css",
    to="/tmp",
    from="~/webpage/v1"
  )
)

# for larger projects, a wrapper function might become handy
prov <- function(
  rel,
  to="/tmp",
  from="~/webpage/v1",
  overwrite=TRUE,
  mode="0777"
){
  provide_file(rel=rel, to=to, from=from, overwrite=overwrite, mode=mode)
}
# let's combine it with a shortcut function for <link>
gen_tag_functions("link")
# now this code produces the same result as the direct call above
my_HTML2 <- link_(
  rel="stylesheet",
  type="text/css",
  href=prov("static/css/bootstrap.min.css")
)
}
}
