% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{delta}
\alias{delta}
\title{The scalar delta}
\usage{
delta(X, proba)
}
\arguments{
\item{X}{a vector.}

\item{proba}{a zero-inflated proportions response.}
}
\value{
\code{Delta} the scalar Delta calculated for the vector \code{x}
and the vector \code{proba}.
}
\description{
Calculate the scalar delta.
This parameter comes from the optimal Spearman’s correlation
when the rank of two vectors \code{X} and \code{proba} are equal except on a given set of indices.
In our context, this set correspond to the zero-values of the vector \code{proba}.
}
\examples{
X = rnorm(100)
proba = runif(100)
proba[sample(1:100,80)]=0
Delta = delta(X,proba)
print(Delta)
}
