% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testZLA.R
\name{testZLA}
\alias{testZLA}
\title{Assess evidence for Zipf's law of abbreviation}
\usage{
testZLA(data, minimum = 1, null = 999, est = "mean", cores = 2)
}
\arguments{
\item{data}{a dataframe containing columns "note" (factor/character; identifies the note/phrase type of each token), "duration" (numeric; describes the duration of each token), and "ID" (factor; identifies the individual that produced each token). Other columns in the dataframe are ignored.}

\item{minimum}{the minimum number of times a note type must appear in the data set to be included in the analysis. Must be a positive integer.}

\item{null}{the number of permutations used to estimate the null distribution. Must be a positive integer 99 or greater.}

\item{est}{takes values "mixed" or "mean." If est = "mixed," then the expected duration for each note type in the population is computed as the intercept of an intercept-only mixed effects model (fit using the lmer() function of lme4) that includes a random effect of individual ID. If est = "mean," then the expected duration for each note type in the population is computed as the weighted mean across all observations in the dataset with each individual weighted equally. The expected durations for note types are used in the permutation algorithm.}

\item{cores}{divides (parallelizes) computation of the null distribution among cores. Cores must be an integer between 1 and the number of cores available on the users machine, inclusive.}
}
\value{
a matrix that reports Kendall's tau and the p-value associated with Kendall's tau computed at both the population and individual levels.
}
\description{
Assesses evidence for Zipf's Law of Abbreviation in a population where samples from the population repertoire can be assigned to individuals.
}
\author{
CD Durrant and R. Tucker Gilman (2023)
}
